// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class CreateEventSubscriptionRequest private constructor(builder: BuilderImpl) {
    /**
     * A boolean value; set to true to activate the subscription, and set to
     * false to create the subscription but not activate it.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * Specifies the Amazon Redshift event categories to be published by the event notification
     * subscription.
     * Values: configuration, management, monitoring, security, pending
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * Specifies the Amazon Redshift event severity to be published by the event notification
     * subscription.
     * Values: ERROR, INFO
     */
    val severity: String? = builder.severity
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
     * notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
     * it.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * A list of one or more identifiers of Amazon Redshift source objects. All of the objects
     * must be of the same type as was specified in the source type parameter. The event
     * subscription will return only events generated by the specified objects. If not
     * specified, then events are returned for all objects within the source type
     * specified.
     * Example: my-cluster-1, my-cluster-2
     * Example: my-snapshot-20131010
     */
    val sourceIds: List<String>? = builder.sourceIds
    /**
     * The type of source that will be generating the events. For example, if you want to
     * be notified of events generated by a cluster, you would set this parameter to cluster.
     * If this value is not specified, events are returned for all Amazon Redshift objects in your
     * Amazon Web Services account. You must specify a source type in order to specify source IDs.
     * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
     */
    val sourceType: String? = builder.sourceType
    /**
     * The name of the event subscription to be created.
     * Constraints:
     * Cannot be null, empty, or blank.
     * Must contain from 1 to 255 alphanumeric characters or hyphens.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val subscriptionName: String? = builder.subscriptionName
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateEventSubscriptionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("severity=$severity,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIds=$sourceIds,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIds?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (severity != other.severity) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIds != other.sourceIds) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateEventSubscriptionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateEventSubscriptionRequest
        /**
         * A boolean value; set to true to activate the subscription, and set to
         * false to create the subscription but not activate it.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * Specifies the Amazon Redshift event categories to be published by the event notification
         * subscription.
         * Values: configuration, management, monitoring, security, pending
         */
        fun eventCategories(eventCategories: List<String>): FluentBuilder
        /**
         * Specifies the Amazon Redshift event severity to be published by the event notification
         * subscription.
         * Values: ERROR, INFO
         */
        fun severity(severity: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
         * notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
         * it.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * A list of one or more identifiers of Amazon Redshift source objects. All of the objects
         * must be of the same type as was specified in the source type parameter. The event
         * subscription will return only events generated by the specified objects. If not
         * specified, then events are returned for all objects within the source type
         * specified.
         * Example: my-cluster-1, my-cluster-2
         * Example: my-snapshot-20131010
         */
        fun sourceIds(sourceIds: List<String>): FluentBuilder
        /**
         * The type of source that will be generating the events. For example, if you want to
         * be notified of events generated by a cluster, you would set this parameter to cluster.
         * If this value is not specified, events are returned for all Amazon Redshift objects in your
         * Amazon Web Services account. You must specify a source type in order to specify source IDs.
         * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
         */
        fun sourceType(sourceType: String): FluentBuilder
        /**
         * The name of the event subscription to be created.
         * Constraints:
         * Cannot be null, empty, or blank.
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun subscriptionName(subscriptionName: String): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A boolean value; set to true to activate the subscription, and set to
         * false to create the subscription but not activate it.
         */
        var enabled: Boolean?
        /**
         * Specifies the Amazon Redshift event categories to be published by the event notification
         * subscription.
         * Values: configuration, management, monitoring, security, pending
         */
        var eventCategories: List<String>?
        /**
         * Specifies the Amazon Redshift event severity to be published by the event notification
         * subscription.
         * Values: ERROR, INFO
         */
        var severity: String?
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
         * notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
         * it.
         */
        var snsTopicArn: String?
        /**
         * A list of one or more identifiers of Amazon Redshift source objects. All of the objects
         * must be of the same type as was specified in the source type parameter. The event
         * subscription will return only events generated by the specified objects. If not
         * specified, then events are returned for all objects within the source type
         * specified.
         * Example: my-cluster-1, my-cluster-2
         * Example: my-snapshot-20131010
         */
        var sourceIds: List<String>?
        /**
         * The type of source that will be generating the events. For example, if you want to
         * be notified of events generated by a cluster, you would set this parameter to cluster.
         * If this value is not specified, events are returned for all Amazon Redshift objects in your
         * Amazon Web Services account. You must specify a source type in order to specify source IDs.
         * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
         */
        var sourceType: String?
        /**
         * The name of the event subscription to be created.
         * Constraints:
         * Cannot be null, empty, or blank.
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var subscriptionName: String?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?

        fun build(): CreateEventSubscriptionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enabled: Boolean? = null
        override var eventCategories: List<String>? = null
        override var severity: String? = null
        override var snsTopicArn: String? = null
        override var sourceIds: List<String>? = null
        override var sourceType: String? = null
        override var subscriptionName: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.severity = x.severity
            this.snsTopicArn = x.snsTopicArn
            this.sourceIds = x.sourceIds
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
            this.tags = x.tags
        }

        override fun build(): CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(this)
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun eventCategories(eventCategories: List<String>): FluentBuilder = apply { this.eventCategories = eventCategories }
        override fun severity(severity: String): FluentBuilder = apply { this.severity = severity }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun sourceIds(sourceIds: List<String>): FluentBuilder = apply { this.sourceIds = sourceIds }
        override fun sourceType(sourceType: String): FluentBuilder = apply { this.sourceType = sourceType }
        override fun subscriptionName(subscriptionName: String): FluentBuilder = apply { this.subscriptionName = subscriptionName }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
