// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class CreateEndpointAccessRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier of the cluster to access.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The Redshift-managed VPC endpoint name.
     * An endpoint name must contain 1-30 characters.
     * Valid characters are A-Z, a-z, 0-9, and hyphen(-).
     * The first character must be a letter.
     * The name can't contain two consecutive hyphens or end with a hyphen.
     */
    val endpointName: String? = builder.endpointName
    /**
     * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     */
    val resourceOwner: String? = builder.resourceOwner
    /**
     * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     */
    val subnetGroupName: String? = builder.subnetGroupName
    /**
     * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateEndpointAccessRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEndpointAccessRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endpointName=$endpointName,")
        append("resourceOwner=$resourceOwner,")
        append("subnetGroupName=$subnetGroupName,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateEndpointAccessRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endpointName != other.endpointName) return false
        if (resourceOwner != other.resourceOwner) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateEndpointAccessRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateEndpointAccessRequest
        /**
         * The cluster identifier of the cluster to access.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The Redshift-managed VPC endpoint name.
         * An endpoint name must contain 1-30 characters.
         * Valid characters are A-Z, a-z, 0-9, and hyphen(-).
         * The first character must be a letter.
         * The name can't contain two consecutive hyphens or end with a hyphen.
         */
        fun endpointName(endpointName: String): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
         */
        fun resourceOwner(resourceOwner: String): FluentBuilder
        /**
         * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
         */
        fun subnetGroupName(subnetGroupName: String): FluentBuilder
        /**
         * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         */
        fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier of the cluster to access.
         */
        var clusterIdentifier: String?
        /**
         * The Redshift-managed VPC endpoint name.
         * An endpoint name must contain 1-30 characters.
         * Valid characters are A-Z, a-z, 0-9, and hyphen(-).
         * The first character must be a letter.
         * The name can't contain two consecutive hyphens or end with a hyphen.
         */
        var endpointName: String?
        /**
         * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
         */
        var resourceOwner: String?
        /**
         * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
         */
        var subnetGroupName: String?
        /**
         * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         */
        var vpcSecurityGroupIds: List<String>?

        fun build(): CreateEndpointAccessRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var endpointName: String? = null
        override var resourceOwner: String? = null
        override var subnetGroupName: String? = null
        override var vpcSecurityGroupIds: List<String>? = null

        constructor(x: CreateEndpointAccessRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.endpointName = x.endpointName
            this.resourceOwner = x.resourceOwner
            this.subnetGroupName = x.subnetGroupName
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        override fun build(): CreateEndpointAccessRequest = CreateEndpointAccessRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun endpointName(endpointName: String): FluentBuilder = apply { this.endpointName = endpointName }
        override fun resourceOwner(resourceOwner: String): FluentBuilder = apply { this.resourceOwner = resourceOwner }
        override fun subnetGroupName(subnetGroupName: String): FluentBuilder = apply { this.subnetGroupName = subnetGroupName }
        override fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder = apply { this.vpcSecurityGroupIds = vpcSecurityGroupIds }
    }
}
