// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class CreateClusterSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier for which you want a snapshot.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual
     * snapshot is retained indefinitely.
     * The value must be either -1 or an integer between 1 and 3,653.
     * The default value is -1.
     */
    val manualSnapshotRetentionPeriod: Int? = builder.manualSnapshotRetentionPeriod
    /**
     * A unique identifier for the snapshot that you are requesting. This identifier must
     * be unique for all snapshots within the Amazon Web Services account.
     * Constraints:
     * Cannot be null, empty, or blank
     * Must contain from 1 to 255 alphanumeric characters or hyphens
     * First character must be a letter
     * Cannot end with a hyphen or contain two consecutive hyphens
     * Example: my-snapshot-id
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateClusterSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterSnapshotRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateClusterSnapshotRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateClusterSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateClusterSnapshotRequest
        /**
         * The cluster identifier for which you want a snapshot.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * A unique identifier for the snapshot that you are requesting. This identifier must
         * be unique for all snapshots within the Amazon Web Services account.
         * Constraints:
         * Cannot be null, empty, or blank
         * Must contain from 1 to 255 alphanumeric characters or hyphens
         * First character must be a letter
         * Cannot end with a hyphen or contain two consecutive hyphens
         * Example: my-snapshot-id
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier for which you want a snapshot.
         */
        var clusterIdentifier: String?
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        var manualSnapshotRetentionPeriod: Int?
        /**
         * A unique identifier for the snapshot that you are requesting. This identifier must
         * be unique for all snapshots within the Amazon Web Services account.
         * Constraints:
         * Cannot be null, empty, or blank
         * Must contain from 1 to 255 alphanumeric characters or hyphens
         * First character must be a letter
         * Cannot end with a hyphen or contain two consecutive hyphens
         * Example: my-snapshot-id
         */
        var snapshotIdentifier: String?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?

        fun build(): CreateClusterSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var manualSnapshotRetentionPeriod: Int? = null
        override var snapshotIdentifier: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateClusterSnapshotRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.snapshotIdentifier = x.snapshotIdentifier
            this.tags = x.tags
        }

        override fun build(): CreateClusterSnapshotRequest = CreateClusterSnapshotRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
