// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class CopyClusterSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual
     * snapshot is retained indefinitely.
     * The value must be either -1 or an integer between 1 and 3,653.
     * The default value is -1.
     */
    val manualSnapshotRetentionPeriod: Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The identifier of the cluster the source snapshot was created from. This parameter
     * is required if your IAM user has a policy containing a snapshot resource element that
     * specifies anything other than * for the cluster name.
     * Constraints:
     * Must be the identifier for a valid cluster.
     */
    val sourceSnapshotClusterIdentifier: String? = builder.sourceSnapshotClusterIdentifier
    /**
     * The identifier for the source snapshot.
     * Constraints:
     * Must be the identifier for a valid automated snapshot whose state is
     * available.
     */
    val sourceSnapshotIdentifier: String? = builder.sourceSnapshotIdentifier
    /**
     * The identifier given to the new manual snapshot.
     * Constraints:
     * Cannot be null, empty, or blank.
     * Must contain from 1 to 255 alphanumeric characters or hyphens.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Must be unique for the Amazon Web Services account that is making the request.
     */
    val targetSnapshotIdentifier: String? = builder.targetSnapshotIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CopyClusterSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CopyClusterSnapshotRequest(")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("sourceSnapshotClusterIdentifier=$sourceSnapshotClusterIdentifier,")
        append("sourceSnapshotIdentifier=$sourceSnapshotIdentifier,")
        append("targetSnapshotIdentifier=$targetSnapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = manualSnapshotRetentionPeriod ?: 0
        result = 31 * result + (sourceSnapshotClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (targetSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CopyClusterSnapshotRequest

        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (sourceSnapshotClusterIdentifier != other.sourceSnapshotClusterIdentifier) return false
        if (sourceSnapshotIdentifier != other.sourceSnapshotIdentifier) return false
        if (targetSnapshotIdentifier != other.targetSnapshotIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CopyClusterSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CopyClusterSnapshotRequest
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The identifier of the cluster the source snapshot was created from. This parameter
         * is required if your IAM user has a policy containing a snapshot resource element that
         * specifies anything other than * for the cluster name.
         * Constraints:
         * Must be the identifier for a valid cluster.
         */
        fun sourceSnapshotClusterIdentifier(sourceSnapshotClusterIdentifier: String): FluentBuilder
        /**
         * The identifier for the source snapshot.
         * Constraints:
         * Must be the identifier for a valid automated snapshot whose state is
         * available.
         */
        fun sourceSnapshotIdentifier(sourceSnapshotIdentifier: String): FluentBuilder
        /**
         * The identifier given to the new manual snapshot.
         * Constraints:
         * Cannot be null, empty, or blank.
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for the Amazon Web Services account that is making the request.
         */
        fun targetSnapshotIdentifier(targetSnapshotIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        var manualSnapshotRetentionPeriod: Int?
        /**
         * The identifier of the cluster the source snapshot was created from. This parameter
         * is required if your IAM user has a policy containing a snapshot resource element that
         * specifies anything other than * for the cluster name.
         * Constraints:
         * Must be the identifier for a valid cluster.
         */
        var sourceSnapshotClusterIdentifier: String?
        /**
         * The identifier for the source snapshot.
         * Constraints:
         * Must be the identifier for a valid automated snapshot whose state is
         * available.
         */
        var sourceSnapshotIdentifier: String?
        /**
         * The identifier given to the new manual snapshot.
         * Constraints:
         * Cannot be null, empty, or blank.
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for the Amazon Web Services account that is making the request.
         */
        var targetSnapshotIdentifier: String?

        fun build(): CopyClusterSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var manualSnapshotRetentionPeriod: Int? = null
        override var sourceSnapshotClusterIdentifier: String? = null
        override var sourceSnapshotIdentifier: String? = null
        override var targetSnapshotIdentifier: String? = null

        constructor(x: CopyClusterSnapshotRequest) : this() {
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.sourceSnapshotClusterIdentifier = x.sourceSnapshotClusterIdentifier
            this.sourceSnapshotIdentifier = x.sourceSnapshotIdentifier
            this.targetSnapshotIdentifier = x.targetSnapshotIdentifier
        }

        override fun build(): CopyClusterSnapshotRequest = CopyClusterSnapshotRequest(this)
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun sourceSnapshotClusterIdentifier(sourceSnapshotClusterIdentifier: String): FluentBuilder = apply { this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier }
        override fun sourceSnapshotIdentifier(sourceSnapshotIdentifier: String): FluentBuilder = apply { this.sourceSnapshotIdentifier = sourceSnapshotIdentifier }
        override fun targetSnapshotIdentifier(targetSnapshotIdentifier: String): FluentBuilder = apply { this.targetSnapshotIdentifier = targetSnapshotIdentifier }
    }
}
