// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Returns the destination region and retention period that are configured for
 * cross-region snapshot copy.
 */
class ClusterSnapshotCopyStatus private constructor(builder: BuilderImpl) {
    /**
     * The destination region that snapshots are automatically copied to when cross-region
     * snapshot copy is enabled.
     */
    val destinationRegion: String? = builder.destinationRegion
    /**
     * The number of days that automated snapshots are retained in the destination region
     * after they are copied from a source region. If the value is -1, the manual snapshot is
     * retained indefinitely.
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: Int = builder.manualSnapshotRetentionPeriod
    /**
     * The number of days that automated snapshots are retained in the destination region
     * after they are copied from a source region.
     */
    val retentionPeriod: Long = builder.retentionPeriod
    /**
     * The name of the snapshot copy grant.
     */
    val snapshotCopyGrantName: String? = builder.snapshotCopyGrantName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterSnapshotCopyStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterSnapshotCopyStatus(")
        append("destinationRegion=$destinationRegion,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("retentionPeriod=$retentionPeriod,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationRegion?.hashCode() ?: 0
        result = 31 * result + (manualSnapshotRetentionPeriod)
        result = 31 * result + (retentionPeriod.hashCode())
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterSnapshotCopyStatus

        if (destinationRegion != other.destinationRegion) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterSnapshotCopyStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterSnapshotCopyStatus
        /**
         * The destination region that snapshots are automatically copied to when cross-region
         * snapshot copy is enabled.
         */
        fun destinationRegion(destinationRegion: String): FluentBuilder
        /**
         * The number of days that automated snapshots are retained in the destination region
         * after they are copied from a source region. If the value is -1, the manual snapshot is
         * retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The number of days that automated snapshots are retained in the destination region
         * after they are copied from a source region.
         */
        fun retentionPeriod(retentionPeriod: Long): FluentBuilder
        /**
         * The name of the snapshot copy grant.
         */
        fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The destination region that snapshots are automatically copied to when cross-region
         * snapshot copy is enabled.
         */
        var destinationRegion: String?
        /**
         * The number of days that automated snapshots are retained in the destination region
         * after they are copied from a source region. If the value is -1, the manual snapshot is
         * retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: Int
        /**
         * The number of days that automated snapshots are retained in the destination region
         * after they are copied from a source region.
         */
        var retentionPeriod: Long
        /**
         * The name of the snapshot copy grant.
         */
        var snapshotCopyGrantName: String?

        fun build(): ClusterSnapshotCopyStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationRegion: String? = null
        override var manualSnapshotRetentionPeriod: Int = 0
        override var retentionPeriod: Long = 0L
        override var snapshotCopyGrantName: String? = null

        constructor(x: ClusterSnapshotCopyStatus) : this() {
            this.destinationRegion = x.destinationRegion
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.retentionPeriod = x.retentionPeriod
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
        }

        override fun build(): ClusterSnapshotCopyStatus = ClusterSnapshotCopyStatus(this)
        override fun destinationRegion(destinationRegion: String): FluentBuilder = apply { this.destinationRegion = destinationRegion }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun retentionPeriod(retentionPeriod: Long): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder = apply { this.snapshotCopyGrantName = snapshotCopyGrantName }
    }
}
