// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a security group.
 */
class ClusterSecurityGroup private constructor(builder: BuilderImpl) {
    /**
     * The name of the cluster security group to which the operation was
     * applied.
     */
    val clusterSecurityGroupName: String? = builder.clusterSecurityGroupName
    /**
     * A description of the security group.
     */
    val description: String? = builder.description
    /**
     * A list of EC2 security groups that are permitted to access clusters associated with
     * this cluster security group.
     */
    val ec2SecurityGroups: List<Ec2SecurityGroup>? = builder.ec2SecurityGroups
    /**
     * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
     * with this cluster security group.
     */
    val ipRanges: List<IpRange>? = builder.ipRanges
    /**
     * The list of tags for the cluster security group.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterSecurityGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterSecurityGroup(")
        append("clusterSecurityGroupName=$clusterSecurityGroupName,")
        append("description=$description,")
        append("ec2SecurityGroups=$ec2SecurityGroups,")
        append("ipRanges=$ipRanges,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterSecurityGroupName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ec2SecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterSecurityGroup

        if (clusterSecurityGroupName != other.clusterSecurityGroupName) return false
        if (description != other.description) return false
        if (ec2SecurityGroups != other.ec2SecurityGroups) return false
        if (ipRanges != other.ipRanges) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterSecurityGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterSecurityGroup
        /**
         * The name of the cluster security group to which the operation was
         * applied.
         */
        fun clusterSecurityGroupName(clusterSecurityGroupName: String): FluentBuilder
        /**
         * A description of the security group.
         */
        fun description(description: String): FluentBuilder
        /**
         * A list of EC2 security groups that are permitted to access clusters associated with
         * this cluster security group.
         */
        fun ec2SecurityGroups(ec2SecurityGroups: List<Ec2SecurityGroup>): FluentBuilder
        /**
         * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
         * with this cluster security group.
         */
        fun ipRanges(ipRanges: List<IpRange>): FluentBuilder
        /**
         * The list of tags for the cluster security group.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the cluster security group to which the operation was
         * applied.
         */
        var clusterSecurityGroupName: String?
        /**
         * A description of the security group.
         */
        var description: String?
        /**
         * A list of EC2 security groups that are permitted to access clusters associated with
         * this cluster security group.
         */
        var ec2SecurityGroups: List<Ec2SecurityGroup>?
        /**
         * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
         * with this cluster security group.
         */
        var ipRanges: List<IpRange>?
        /**
         * The list of tags for the cluster security group.
         */
        var tags: List<Tag>?

        fun build(): ClusterSecurityGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterSecurityGroupName: String? = null
        override var description: String? = null
        override var ec2SecurityGroups: List<Ec2SecurityGroup>? = null
        override var ipRanges: List<IpRange>? = null
        override var tags: List<Tag>? = null

        constructor(x: ClusterSecurityGroup) : this() {
            this.clusterSecurityGroupName = x.clusterSecurityGroupName
            this.description = x.description
            this.ec2SecurityGroups = x.ec2SecurityGroups
            this.ipRanges = x.ipRanges
            this.tags = x.tags
        }

        override fun build(): ClusterSecurityGroup = ClusterSecurityGroup(this)
        override fun clusterSecurityGroupName(clusterSecurityGroupName: String): FluentBuilder = apply { this.clusterSecurityGroupName = clusterSecurityGroupName }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun ec2SecurityGroups(ec2SecurityGroups: List<Ec2SecurityGroup>): FluentBuilder = apply { this.ec2SecurityGroups = ec2SecurityGroups }
        override fun ipRanges(ipRanges: List<IpRange>): FluentBuilder = apply { this.ipRanges = ipRanges }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
