// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of a parameter group.
 */
class ClusterParameterStatus private constructor(builder: BuilderImpl) {
    /**
     * The error that prevented the parameter from being applied to the
     * database.
     */
    val parameterApplyErrorDescription: String? = builder.parameterApplyErrorDescription
    /**
     * The status of the parameter that indicates whether the parameter is in sync with
     * the database, waiting for a cluster reboot, or encountered an error when being
     * applied.
     * The following are possible statuses and descriptions.
     * in-sync: The parameter value is in sync with the
     * database.
     * pending-reboot: The parameter value will be applied after the
     * cluster reboots.
     * applying: The parameter value is being applied to the
     * database.
     * invalid-parameter: Cannot apply the parameter value because it has
     * an invalid value or syntax.
     * apply-deferred: The parameter contains static property changes. The
     * changes are deferred until the cluster reboots.
     * apply-error: Cannot connect to the cluster. The parameter change
     * will be applied after the cluster reboots.
     * unknown-error: Cannot apply the parameter change right now. The
     * change will be applied after the cluster reboots.
     */
    val parameterApplyStatus: String? = builder.parameterApplyStatus
    /**
     * The name of the parameter.
     */
    val parameterName: String? = builder.parameterName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterParameterStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterParameterStatus(")
        append("parameterApplyErrorDescription=$parameterApplyErrorDescription,")
        append("parameterApplyStatus=$parameterApplyStatus,")
        append("parameterName=$parameterName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameterApplyErrorDescription?.hashCode() ?: 0
        result = 31 * result + (parameterApplyStatus?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterParameterStatus

        if (parameterApplyErrorDescription != other.parameterApplyErrorDescription) return false
        if (parameterApplyStatus != other.parameterApplyStatus) return false
        if (parameterName != other.parameterName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterParameterStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterParameterStatus
        /**
         * The error that prevented the parameter from being applied to the
         * database.
         */
        fun parameterApplyErrorDescription(parameterApplyErrorDescription: String): FluentBuilder
        /**
         * The status of the parameter that indicates whether the parameter is in sync with
         * the database, waiting for a cluster reboot, or encountered an error when being
         * applied.
         * The following are possible statuses and descriptions.
         * in-sync: The parameter value is in sync with the
         * database.
         * pending-reboot: The parameter value will be applied after the
         * cluster reboots.
         * applying: The parameter value is being applied to the
         * database.
         * invalid-parameter: Cannot apply the parameter value because it has
         * an invalid value or syntax.
         * apply-deferred: The parameter contains static property changes. The
         * changes are deferred until the cluster reboots.
         * apply-error: Cannot connect to the cluster. The parameter change
         * will be applied after the cluster reboots.
         * unknown-error: Cannot apply the parameter change right now. The
         * change will be applied after the cluster reboots.
         */
        fun parameterApplyStatus(parameterApplyStatus: String): FluentBuilder
        /**
         * The name of the parameter.
         */
        fun parameterName(parameterName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The error that prevented the parameter from being applied to the
         * database.
         */
        var parameterApplyErrorDescription: String?
        /**
         * The status of the parameter that indicates whether the parameter is in sync with
         * the database, waiting for a cluster reboot, or encountered an error when being
         * applied.
         * The following are possible statuses and descriptions.
         * in-sync: The parameter value is in sync with the
         * database.
         * pending-reboot: The parameter value will be applied after the
         * cluster reboots.
         * applying: The parameter value is being applied to the
         * database.
         * invalid-parameter: Cannot apply the parameter value because it has
         * an invalid value or syntax.
         * apply-deferred: The parameter contains static property changes. The
         * changes are deferred until the cluster reboots.
         * apply-error: Cannot connect to the cluster. The parameter change
         * will be applied after the cluster reboots.
         * unknown-error: Cannot apply the parameter change right now. The
         * change will be applied after the cluster reboots.
         */
        var parameterApplyStatus: String?
        /**
         * The name of the parameter.
         */
        var parameterName: String?

        fun build(): ClusterParameterStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var parameterApplyErrorDescription: String? = null
        override var parameterApplyStatus: String? = null
        override var parameterName: String? = null

        constructor(x: ClusterParameterStatus) : this() {
            this.parameterApplyErrorDescription = x.parameterApplyErrorDescription
            this.parameterApplyStatus = x.parameterApplyStatus
            this.parameterName = x.parameterName
        }

        override fun build(): ClusterParameterStatus = ClusterParameterStatus(this)
        override fun parameterApplyErrorDescription(parameterApplyErrorDescription: String): FluentBuilder = apply { this.parameterApplyErrorDescription = parameterApplyErrorDescription }
        override fun parameterApplyStatus(parameterApplyStatus: String): FluentBuilder = apply { this.parameterApplyStatus = parameterApplyStatus }
        override fun parameterName(parameterName: String): FluentBuilder = apply { this.parameterName = parameterName }
    }
}
