// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * An Identity and Access Management (IAM) role that can be used by the associated
 * Amazon Redshift cluster to access other Amazon Web Services services.
 */
class ClusterIamRole private constructor(builder: BuilderImpl) {
    /**
     * A value that describes the status of the IAM role's association with an Amazon
     * Redshift cluster.
     * The following are possible statuses and descriptions.
     * in-sync: The role is available for use by the cluster.
     * adding: The role is in the process of being associated with the
     * cluster.
     * removing: The role is in the process of being disassociated with
     * the cluster.
     */
    val applyStatus: String? = builder.applyStatus
    /**
     * The Amazon Resource Name (ARN) of the IAM role, for example,
     * arn:aws:iam::123456789012:role/RedshiftCopyUnload.
     */
    val iamRoleArn: String? = builder.iamRoleArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterIamRole = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterIamRole(")
        append("applyStatus=$applyStatus,")
        append("iamRoleArn=$iamRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyStatus?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterIamRole

        if (applyStatus != other.applyStatus) return false
        if (iamRoleArn != other.iamRoleArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterIamRole = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterIamRole
        /**
         * A value that describes the status of the IAM role's association with an Amazon
         * Redshift cluster.
         * The following are possible statuses and descriptions.
         * in-sync: The role is available for use by the cluster.
         * adding: The role is in the process of being associated with the
         * cluster.
         * removing: The role is in the process of being disassociated with
         * the cluster.
         */
        fun applyStatus(applyStatus: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role, for example,
         * arn:aws:iam::123456789012:role/RedshiftCopyUnload.
         */
        fun iamRoleArn(iamRoleArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that describes the status of the IAM role's association with an Amazon
         * Redshift cluster.
         * The following are possible statuses and descriptions.
         * in-sync: The role is available for use by the cluster.
         * adding: The role is in the process of being associated with the
         * cluster.
         * removing: The role is in the process of being disassociated with
         * the cluster.
         */
        var applyStatus: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role, for example,
         * arn:aws:iam::123456789012:role/RedshiftCopyUnload.
         */
        var iamRoleArn: String?

        fun build(): ClusterIamRole
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applyStatus: String? = null
        override var iamRoleArn: String? = null

        constructor(x: ClusterIamRole) : this() {
            this.applyStatus = x.applyStatus
            this.iamRoleArn = x.iamRoleArn
        }

        override fun build(): ClusterIamRole = ClusterIamRole(this)
        override fun applyStatus(applyStatus: String): FluentBuilder = apply { this.applyStatus = applyStatus }
        override fun iamRoleArn(iamRoleArn: String): FluentBuilder = apply { this.iamRoleArn = iamRoleArn }
    }
}
