// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a ClusterDbRevision.
 */
class ClusterDbRevision private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of the cluster.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A string representing the current cluster version.
     */
    val currentDatabaseRevision: String? = builder.currentDatabaseRevision
    /**
     * The date on which the database revision was released.
     */
    val databaseRevisionReleaseDate: Instant? = builder.databaseRevisionReleaseDate
    /**
     * A list of RevisionTarget objects, where each object describes the
     * database revision that a cluster can be updated to.
     */
    val revisionTargets: List<RevisionTarget>? = builder.revisionTargets

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterDbRevision = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterDbRevision(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("currentDatabaseRevision=$currentDatabaseRevision,")
        append("databaseRevisionReleaseDate=$databaseRevisionReleaseDate,")
        append("revisionTargets=$revisionTargets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (currentDatabaseRevision?.hashCode() ?: 0)
        result = 31 * result + (databaseRevisionReleaseDate?.hashCode() ?: 0)
        result = 31 * result + (revisionTargets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterDbRevision

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (currentDatabaseRevision != other.currentDatabaseRevision) return false
        if (databaseRevisionReleaseDate != other.databaseRevisionReleaseDate) return false
        if (revisionTargets != other.revisionTargets) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterDbRevision = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterDbRevision
        /**
         * The unique identifier of the cluster.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A string representing the current cluster version.
         */
        fun currentDatabaseRevision(currentDatabaseRevision: String): FluentBuilder
        /**
         * The date on which the database revision was released.
         */
        fun databaseRevisionReleaseDate(databaseRevisionReleaseDate: Instant): FluentBuilder
        /**
         * A list of RevisionTarget objects, where each object describes the
         * database revision that a cluster can be updated to.
         */
        fun revisionTargets(revisionTargets: List<RevisionTarget>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of the cluster.
         */
        var clusterIdentifier: String?
        /**
         * A string representing the current cluster version.
         */
        var currentDatabaseRevision: String?
        /**
         * The date on which the database revision was released.
         */
        var databaseRevisionReleaseDate: Instant?
        /**
         * A list of RevisionTarget objects, where each object describes the
         * database revision that a cluster can be updated to.
         */
        var revisionTargets: List<RevisionTarget>?

        fun build(): ClusterDbRevision
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var currentDatabaseRevision: String? = null
        override var databaseRevisionReleaseDate: Instant? = null
        override var revisionTargets: List<RevisionTarget>? = null

        constructor(x: ClusterDbRevision) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.currentDatabaseRevision = x.currentDatabaseRevision
            this.databaseRevisionReleaseDate = x.databaseRevisionReleaseDate
            this.revisionTargets = x.revisionTargets
        }

        override fun build(): ClusterDbRevision = ClusterDbRevision(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun currentDatabaseRevision(currentDatabaseRevision: String): FluentBuilder = apply { this.currentDatabaseRevision = currentDatabaseRevision }
        override fun databaseRevisionReleaseDate(databaseRevisionReleaseDate: Instant): FluentBuilder = apply { this.databaseRevisionReleaseDate = databaseRevisionReleaseDate }
        override fun revisionTargets(revisionTargets: List<RevisionTarget>): FluentBuilder = apply { this.revisionTargets = revisionTargets }
    }
}
