// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a cluster.
 */
class Cluster private constructor(builder: BuilderImpl) {
    /**
     * A boolean value that, if true, indicates that major version upgrades
     * will be applied automatically to the cluster during the maintenance window.
     */
    val allowVersionUpgrade: Boolean = builder.allowVersionUpgrade
    /**
     * The AQUA (Advanced Query Accelerator) configuration of the cluster.
     */
    val aquaConfiguration: AquaConfiguration? = builder.aquaConfiguration
    /**
     * The number of days that automatic cluster snapshots are retained.
     */
    val automatedSnapshotRetentionPeriod: Int = builder.automatedSnapshotRetentionPeriod
    /**
     * The name of the Availability Zone in which the cluster is located.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * Describes the status of the Availability Zone relocation operation.
     */
    val availabilityZoneRelocationStatus: String? = builder.availabilityZoneRelocationStatus
    /**
     * The availability status of the cluster for queries. Possible values are the following:
     * Available - The cluster is available for queries.
     * Unavailable - The cluster is not available for queries.
     * Maintenance - The cluster is intermittently available for queries due to maintenance activities.
     * Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.
     * Failed - The cluster failed and is not available for queries.
     */
    val clusterAvailabilityStatus: String? = builder.clusterAvailabilityStatus
    /**
     * The date and time that the cluster was created.
     */
    val clusterCreateTime: Instant? = builder.clusterCreateTime
    /**
     * The unique identifier of the cluster.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The namespace Amazon Resource Name (ARN) of the cluster.
     */
    val clusterNamespaceArn: String? = builder.clusterNamespaceArn
    /**
     * The nodes in the cluster.
     */
    val clusterNodes: List<ClusterNode>? = builder.clusterNodes
    /**
     * The list of cluster parameter groups that are associated with this cluster. Each
     * parameter group in the list is returned with its status.
     */
    val clusterParameterGroups: List<ClusterParameterGroupStatus>? = builder.clusterParameterGroups
    /**
     * The public key for the cluster.
     */
    val clusterPublicKey: String? = builder.clusterPublicKey
    /**
     * The specific revision number of the database in the cluster.
     */
    val clusterRevisionNumber: String? = builder.clusterRevisionNumber
    /**
     * A list of cluster security group that are associated with the cluster. Each
     * security group is represented by an element that contains
     * ClusterSecurityGroup.Name and ClusterSecurityGroup.Status
     * subelements.
     * Cluster security groups are used when the cluster is not created in an Amazon
     * Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups,
     * which are listed by the VpcSecurityGroups parameter.
     */
    val clusterSecurityGroups: List<ClusterSecurityGroupMembership>? = builder.clusterSecurityGroups
    /**
     * A value that returns the destination region and retention period that are
     * configured for cross-region snapshot copy.
     */
    val clusterSnapshotCopyStatus: ClusterSnapshotCopyStatus? = builder.clusterSnapshotCopyStatus
    /**
     * The current state of the cluster. Possible values are the following:
     * available
     * available, prep-for-resize
     * available, resize-cleanup
     * cancelling-resize
     * creating
     * deleting
     * final-snapshot
     * hardware-failure
     * incompatible-hsm
     * incompatible-network
     * incompatible-parameters
     * incompatible-restore
     * modifying
     * paused
     * rebooting
     * renaming
     * resizing
     * rotating-keys
     * storage-full
     * updating-hsm
     */
    val clusterStatus: String? = builder.clusterStatus
    /**
     * The name of the subnet group that is associated with the cluster. This parameter is
     * valid only when the cluster is in a VPC.
     */
    val clusterSubnetGroupName: String? = builder.clusterSubnetGroupName
    /**
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    val clusterVersion: String? = builder.clusterVersion
    /**
     *
     */
    val dataTransferProgress: DataTransferProgress? = builder.dataTransferProgress
    /**
     * The name of the initial database that was created when the cluster was created.
     * This same name is returned for the life of the cluster. If an initial database was not
     * specified, a database named devdev was created by default.
     */
    val dbName: String? = builder.dbName
    /**
     * Describes a group of DeferredMaintenanceWindow objects.
     */
    val deferredMaintenanceWindows: List<DeferredMaintenanceWindow>? = builder.deferredMaintenanceWindows
    /**
     * The status of the elastic IP (EIP) address.
     */
    val elasticIpStatus: ElasticIpStatus? = builder.elasticIpStatus
    /**
     * The number of nodes that you can resize the cluster to with the elastic resize method.
     */
    val elasticResizeNumberOfNodeOptions: String? = builder.elasticResizeNumberOfNodeOptions
    /**
     * A boolean value that, if true, indicates that data in the cluster is
     * encrypted at rest.
     */
    val encrypted: Boolean = builder.encrypted
    /**
     * The connection endpoint.
     */
    val endpoint: Endpoint? = builder.endpoint
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing
     * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
     * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
     * the Amazon Redshift Cluster Management Guide.
     * If this option is true, enhanced VPC routing is enabled.
     * Default: false
     */
    val enhancedVpcRouting: Boolean = builder.enhancedVpcRouting
    /**
     * The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled.
     */
    val expectedNextSnapshotScheduleTime: Instant? = builder.expectedNextSnapshotScheduleTime
    /**
     * The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled.  Possible values are the following:
     * OnTrack - The next snapshot is expected to be taken on time.
     * Pending - The next snapshot is pending to be taken.
     */
    val expectedNextSnapshotScheduleTimeStatus: String? = builder.expectedNextSnapshotScheduleTimeStatus
    /**
     * A value that reports whether the Amazon Redshift cluster has finished applying any
     * hardware security module (HSM) settings changes specified in a modify cluster
     * command.
     * Values: active, applying
     */
    val hsmStatus: HsmStatus? = builder.hsmStatus
    /**
     * A list of Identity and Access Management (IAM) roles that can be used by the
     * cluster to access other Amazon Web Services services.
     */
    val iamRoles: List<ClusterIamRole>? = builder.iamRoles
    /**
     * The Key Management Service (KMS) key ID of the encryption key used to
     * encrypt data in the cluster.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the cluster.
     */
    val maintenanceTrackName: String? = builder.maintenanceTrackName
    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the
     * snapshot is retained indefinitely. This setting doesn't change the retention period
     * of existing snapshots.
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: Int = builder.manualSnapshotRetentionPeriod
    /**
     * The admin user name for the cluster. This name is used to connect to the database
     * that is specified in the DBName parameter.
     */
    val masterUsername: String? = builder.masterUsername
    /**
     * The status of a modify operation, if any, initiated for the cluster.
     */
    val modifyStatus: String? = builder.modifyStatus
    /**
     * The date and time in UTC when system maintenance can begin.
     */
    val nextMaintenanceWindowStartTime: Instant? = builder.nextMaintenanceWindowStartTime
    /**
     * The node type for the nodes in the cluster.
     */
    val nodeType: String? = builder.nodeType
    /**
     * The number of compute nodes in the cluster.
     */
    val numberOfNodes: Int = builder.numberOfNodes
    /**
     * Cluster operations that are waiting to be started.
     */
    val pendingActions: List<String>? = builder.pendingActions
    /**
     * A value that, if present, indicates that changes to the cluster are pending.
     * Specific pending changes are identified by subelements.
     */
    val pendingModifiedValues: PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The weekly time range, in Universal Coordinated Time (UTC), during which system
     * maintenance can occur.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * A boolean value that, if true, indicates that the cluster can be
     * accessed from a public network.
     */
    val publiclyAccessible: Boolean = builder.publiclyAccessible
    /**
     * Returns the following:
     * AllowCancelResize: a boolean value indicating if the resize operation can be
     * cancelled.
     * ResizeType: Returns ClassicResize
     */
    val resizeInfo: ResizeInfo? = builder.resizeInfo
    /**
     * A value that describes the status of a cluster restore action. This parameter
     * returns null if the cluster was not created by restoring a snapshot.
     */
    val restoreStatus: RestoreStatus? = builder.restoreStatus
    /**
     * A unique identifier for the cluster snapshot schedule.
     */
    val snapshotScheduleIdentifier: String? = builder.snapshotScheduleIdentifier
    /**
     * The current state of the cluster snapshot schedule.
     */
    val snapshotScheduleState: ScheduleState? = builder.snapshotScheduleState
    /**
     * The list of tags for the cluster.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The total storage capacity of the cluster in megabytes.
     */
    val totalStorageCapacityInMegaBytes: Long? = builder.totalStorageCapacityInMegaBytes
    /**
     * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
     */
    val vpcId: String? = builder.vpcId
    /**
     * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are
     * associated with the cluster. This parameter is returned only if the cluster is in a
     * VPC.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Cluster = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("aquaConfiguration=$aquaConfiguration,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneRelocationStatus=$availabilityZoneRelocationStatus,")
        append("clusterAvailabilityStatus=$clusterAvailabilityStatus,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterNamespaceArn=$clusterNamespaceArn,")
        append("clusterNodes=$clusterNodes,")
        append("clusterParameterGroups=$clusterParameterGroups,")
        append("clusterPublicKey=$clusterPublicKey,")
        append("clusterRevisionNumber=$clusterRevisionNumber,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterSnapshotCopyStatus=$clusterSnapshotCopyStatus,")
        append("clusterStatus=$clusterStatus,")
        append("clusterSubnetGroupName=$clusterSubnetGroupName,")
        append("clusterVersion=$clusterVersion,")
        append("dataTransferProgress=$dataTransferProgress,")
        append("dbName=$dbName,")
        append("deferredMaintenanceWindows=$deferredMaintenanceWindows,")
        append("elasticIpStatus=$elasticIpStatus,")
        append("elasticResizeNumberOfNodeOptions=$elasticResizeNumberOfNodeOptions,")
        append("encrypted=$encrypted,")
        append("endpoint=$endpoint,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("expectedNextSnapshotScheduleTime=$expectedNextSnapshotScheduleTime,")
        append("expectedNextSnapshotScheduleTimeStatus=$expectedNextSnapshotScheduleTimeStatus,")
        append("hsmStatus=$hsmStatus,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUsername=$masterUsername,")
        append("modifyStatus=$modifyStatus,")
        append("nextMaintenanceWindowStartTime=$nextMaintenanceWindowStartTime,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("pendingActions=$pendingActions,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("resizeInfo=$resizeInfo,")
        append("restoreStatus=$restoreStatus,")
        append("snapshotScheduleIdentifier=$snapshotScheduleIdentifier,")
        append("snapshotScheduleState=$snapshotScheduleState,")
        append("tags=$tags,")
        append("totalStorageCapacityInMegaBytes=$totalStorageCapacityInMegaBytes,")
        append("vpcId=$vpcId,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowVersionUpgrade.hashCode()
        result = 31 * result + (aquaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (automatedSnapshotRetentionPeriod)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneRelocationStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterAvailabilityStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterNamespaceArn?.hashCode() ?: 0)
        result = 31 * result + (clusterNodes?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterPublicKey?.hashCode() ?: 0)
        result = 31 * result + (clusterRevisionNumber?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterSnapshotCopyStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (dataTransferProgress?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (deferredMaintenanceWindows?.hashCode() ?: 0)
        result = 31 * result + (elasticIpStatus?.hashCode() ?: 0)
        result = 31 * result + (elasticResizeNumberOfNodeOptions?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting.hashCode())
        result = 31 * result + (expectedNextSnapshotScheduleTime?.hashCode() ?: 0)
        result = 31 * result + (expectedNextSnapshotScheduleTimeStatus?.hashCode() ?: 0)
        result = 31 * result + (hsmStatus?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (modifyStatus?.hashCode() ?: 0)
        result = 31 * result + (nextMaintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes)
        result = 31 * result + (pendingActions?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (resizeInfo?.hashCode() ?: 0)
        result = 31 * result + (restoreStatus?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleState?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalStorageCapacityInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Cluster

        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (aquaConfiguration != other.aquaConfiguration) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneRelocationStatus != other.availabilityZoneRelocationStatus) return false
        if (clusterAvailabilityStatus != other.clusterAvailabilityStatus) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterNamespaceArn != other.clusterNamespaceArn) return false
        if (clusterNodes != other.clusterNodes) return false
        if (clusterParameterGroups != other.clusterParameterGroups) return false
        if (clusterPublicKey != other.clusterPublicKey) return false
        if (clusterRevisionNumber != other.clusterRevisionNumber) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterSnapshotCopyStatus != other.clusterSnapshotCopyStatus) return false
        if (clusterStatus != other.clusterStatus) return false
        if (clusterSubnetGroupName != other.clusterSubnetGroupName) return false
        if (clusterVersion != other.clusterVersion) return false
        if (dataTransferProgress != other.dataTransferProgress) return false
        if (dbName != other.dbName) return false
        if (deferredMaintenanceWindows != other.deferredMaintenanceWindows) return false
        if (elasticIpStatus != other.elasticIpStatus) return false
        if (elasticResizeNumberOfNodeOptions != other.elasticResizeNumberOfNodeOptions) return false
        if (encrypted != other.encrypted) return false
        if (endpoint != other.endpoint) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (expectedNextSnapshotScheduleTime != other.expectedNextSnapshotScheduleTime) return false
        if (expectedNextSnapshotScheduleTimeStatus != other.expectedNextSnapshotScheduleTimeStatus) return false
        if (hsmStatus != other.hsmStatus) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUsername != other.masterUsername) return false
        if (modifyStatus != other.modifyStatus) return false
        if (nextMaintenanceWindowStartTime != other.nextMaintenanceWindowStartTime) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (pendingActions != other.pendingActions) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (resizeInfo != other.resizeInfo) return false
        if (restoreStatus != other.restoreStatus) return false
        if (snapshotScheduleIdentifier != other.snapshotScheduleIdentifier) return false
        if (snapshotScheduleState != other.snapshotScheduleState) return false
        if (tags != other.tags) return false
        if (totalStorageCapacityInMegaBytes != other.totalStorageCapacityInMegaBytes) return false
        if (vpcId != other.vpcId) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Cluster = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Cluster
        /**
         * A boolean value that, if true, indicates that major version upgrades
         * will be applied automatically to the cluster during the maintenance window.
         */
        fun allowVersionUpgrade(allowVersionUpgrade: Boolean): FluentBuilder
        /**
         * The AQUA (Advanced Query Accelerator) configuration of the cluster.
         */
        fun aquaConfiguration(aquaConfiguration: AquaConfiguration): FluentBuilder
        /**
         * The number of days that automatic cluster snapshots are retained.
         */
        fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The name of the Availability Zone in which the cluster is located.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * Describes the status of the Availability Zone relocation operation.
         */
        fun availabilityZoneRelocationStatus(availabilityZoneRelocationStatus: String): FluentBuilder
        /**
         * The availability status of the cluster for queries. Possible values are the following:
         * Available - The cluster is available for queries.
         * Unavailable - The cluster is not available for queries.
         * Maintenance - The cluster is intermittently available for queries due to maintenance activities.
         * Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.
         * Failed - The cluster failed and is not available for queries.
         */
        fun clusterAvailabilityStatus(clusterAvailabilityStatus: String): FluentBuilder
        /**
         * The date and time that the cluster was created.
         */
        fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder
        /**
         * The unique identifier of the cluster.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The namespace Amazon Resource Name (ARN) of the cluster.
         */
        fun clusterNamespaceArn(clusterNamespaceArn: String): FluentBuilder
        /**
         * The nodes in the cluster.
         */
        fun clusterNodes(clusterNodes: List<ClusterNode>): FluentBuilder
        /**
         * The list of cluster parameter groups that are associated with this cluster. Each
         * parameter group in the list is returned with its status.
         */
        fun clusterParameterGroups(clusterParameterGroups: List<ClusterParameterGroupStatus>): FluentBuilder
        /**
         * The public key for the cluster.
         */
        fun clusterPublicKey(clusterPublicKey: String): FluentBuilder
        /**
         * The specific revision number of the database in the cluster.
         */
        fun clusterRevisionNumber(clusterRevisionNumber: String): FluentBuilder
        /**
         * A list of cluster security group that are associated with the cluster. Each
         * security group is represented by an element that contains
         * ClusterSecurityGroup.Name and ClusterSecurityGroup.Status
         * subelements.
         * Cluster security groups are used when the cluster is not created in an Amazon
         * Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups,
         * which are listed by the VpcSecurityGroups parameter.
         */
        fun clusterSecurityGroups(clusterSecurityGroups: List<ClusterSecurityGroupMembership>): FluentBuilder
        /**
         * A value that returns the destination region and retention period that are
         * configured for cross-region snapshot copy.
         */
        fun clusterSnapshotCopyStatus(clusterSnapshotCopyStatus: ClusterSnapshotCopyStatus): FluentBuilder
        /**
         * The current state of the cluster. Possible values are the following:
         * available
         * available, prep-for-resize
         * available, resize-cleanup
         * cancelling-resize
         * creating
         * deleting
         * final-snapshot
         * hardware-failure
         * incompatible-hsm
         * incompatible-network
         * incompatible-parameters
         * incompatible-restore
         * modifying
         * paused
         * rebooting
         * renaming
         * resizing
         * rotating-keys
         * storage-full
         * updating-hsm
         */
        fun clusterStatus(clusterStatus: String): FluentBuilder
        /**
         * The name of the subnet group that is associated with the cluster. This parameter is
         * valid only when the cluster is in a VPC.
         */
        fun clusterSubnetGroupName(clusterSubnetGroupName: String): FluentBuilder
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        fun clusterVersion(clusterVersion: String): FluentBuilder
        /**
         *
         */
        fun dataTransferProgress(dataTransferProgress: DataTransferProgress): FluentBuilder
        /**
         * The name of the initial database that was created when the cluster was created.
         * This same name is returned for the life of the cluster. If an initial database was not
         * specified, a database named devdev was created by default.
         */
        fun dbName(dbName: String): FluentBuilder
        /**
         * Describes a group of DeferredMaintenanceWindow objects.
         */
        fun deferredMaintenanceWindows(deferredMaintenanceWindows: List<DeferredMaintenanceWindow>): FluentBuilder
        /**
         * The status of the elastic IP (EIP) address.
         */
        fun elasticIpStatus(elasticIpStatus: ElasticIpStatus): FluentBuilder
        /**
         * The number of nodes that you can resize the cluster to with the elastic resize method.
         */
        fun elasticResizeNumberOfNodeOptions(elasticResizeNumberOfNodeOptions: String): FluentBuilder
        /**
         * A boolean value that, if true, indicates that data in the cluster is
         * encrypted at rest.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The connection endpoint.
         */
        fun endpoint(endpoint: Endpoint): FluentBuilder
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder
        /**
         * The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled.
         */
        fun expectedNextSnapshotScheduleTime(expectedNextSnapshotScheduleTime: Instant): FluentBuilder
        /**
         * The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled.  Possible values are the following:
         * OnTrack - The next snapshot is expected to be taken on time.
         * Pending - The next snapshot is pending to be taken.
         */
        fun expectedNextSnapshotScheduleTimeStatus(expectedNextSnapshotScheduleTimeStatus: String): FluentBuilder
        /**
         * A value that reports whether the Amazon Redshift cluster has finished applying any
         * hardware security module (HSM) settings changes specified in a modify cluster
         * command.
         * Values: active, applying
         */
        fun hsmStatus(hsmStatus: HsmStatus): FluentBuilder
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the
         * cluster to access other Amazon Web Services services.
         */
        fun iamRoles(iamRoles: List<ClusterIamRole>): FluentBuilder
        /**
         * The Key Management Service (KMS) key ID of the encryption key used to
         * encrypt data in the cluster.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the maintenance track for the cluster.
         */
        fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the
         * snapshot is retained indefinitely. This setting doesn't change the retention period
         * of existing snapshots.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The admin user name for the cluster. This name is used to connect to the database
         * that is specified in the DBName parameter.
         */
        fun masterUsername(masterUsername: String): FluentBuilder
        /**
         * The status of a modify operation, if any, initiated for the cluster.
         */
        fun modifyStatus(modifyStatus: String): FluentBuilder
        /**
         * The date and time in UTC when system maintenance can begin.
         */
        fun nextMaintenanceWindowStartTime(nextMaintenanceWindowStartTime: Instant): FluentBuilder
        /**
         * The node type for the nodes in the cluster.
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The number of compute nodes in the cluster.
         */
        fun numberOfNodes(numberOfNodes: Int): FluentBuilder
        /**
         * Cluster operations that are waiting to be started.
         */
        fun pendingActions(pendingActions: List<String>): FluentBuilder
        /**
         * A value that, if present, indicates that changes to the cluster are pending.
         * Specific pending changes are identified by subelements.
         */
        fun pendingModifiedValues(pendingModifiedValues: PendingModifiedValues): FluentBuilder
        /**
         * The weekly time range, in Universal Coordinated Time (UTC), during which system
         * maintenance can occur.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * A boolean value that, if true, indicates that the cluster can be
         * accessed from a public network.
         */
        fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder
        /**
         * Returns the following:
         * AllowCancelResize: a boolean value indicating if the resize operation can be
         * cancelled.
         * ResizeType: Returns ClassicResize
         */
        fun resizeInfo(resizeInfo: ResizeInfo): FluentBuilder
        /**
         * A value that describes the status of a cluster restore action. This parameter
         * returns null if the cluster was not created by restoring a snapshot.
         */
        fun restoreStatus(restoreStatus: RestoreStatus): FluentBuilder
        /**
         * A unique identifier for the cluster snapshot schedule.
         */
        fun snapshotScheduleIdentifier(snapshotScheduleIdentifier: String): FluentBuilder
        /**
         * The current state of the cluster snapshot schedule.
         */
        fun snapshotScheduleState(snapshotScheduleState: ScheduleState): FluentBuilder
        /**
         * The list of tags for the cluster.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The total storage capacity of the cluster in megabytes.
         */
        fun totalStorageCapacityInMegaBytes(totalStorageCapacityInMegaBytes: Long): FluentBuilder
        /**
         * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are
         * associated with the cluster. This parameter is returned only if the cluster is in a
         * VPC.
         */
        fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A boolean value that, if true, indicates that major version upgrades
         * will be applied automatically to the cluster during the maintenance window.
         */
        var allowVersionUpgrade: Boolean
        /**
         * The AQUA (Advanced Query Accelerator) configuration of the cluster.
         */
        var aquaConfiguration: AquaConfiguration?
        /**
         * The number of days that automatic cluster snapshots are retained.
         */
        var automatedSnapshotRetentionPeriod: Int
        /**
         * The name of the Availability Zone in which the cluster is located.
         */
        var availabilityZone: String?
        /**
         * Describes the status of the Availability Zone relocation operation.
         */
        var availabilityZoneRelocationStatus: String?
        /**
         * The availability status of the cluster for queries. Possible values are the following:
         * Available - The cluster is available for queries.
         * Unavailable - The cluster is not available for queries.
         * Maintenance - The cluster is intermittently available for queries due to maintenance activities.
         * Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.
         * Failed - The cluster failed and is not available for queries.
         */
        var clusterAvailabilityStatus: String?
        /**
         * The date and time that the cluster was created.
         */
        var clusterCreateTime: Instant?
        /**
         * The unique identifier of the cluster.
         */
        var clusterIdentifier: String?
        /**
         * The namespace Amazon Resource Name (ARN) of the cluster.
         */
        var clusterNamespaceArn: String?
        /**
         * The nodes in the cluster.
         */
        var clusterNodes: List<ClusterNode>?
        /**
         * The list of cluster parameter groups that are associated with this cluster. Each
         * parameter group in the list is returned with its status.
         */
        var clusterParameterGroups: List<ClusterParameterGroupStatus>?
        /**
         * The public key for the cluster.
         */
        var clusterPublicKey: String?
        /**
         * The specific revision number of the database in the cluster.
         */
        var clusterRevisionNumber: String?
        /**
         * A list of cluster security group that are associated with the cluster. Each
         * security group is represented by an element that contains
         * ClusterSecurityGroup.Name and ClusterSecurityGroup.Status
         * subelements.
         * Cluster security groups are used when the cluster is not created in an Amazon
         * Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups,
         * which are listed by the VpcSecurityGroups parameter.
         */
        var clusterSecurityGroups: List<ClusterSecurityGroupMembership>?
        /**
         * A value that returns the destination region and retention period that are
         * configured for cross-region snapshot copy.
         */
        var clusterSnapshotCopyStatus: ClusterSnapshotCopyStatus?
        /**
         * The current state of the cluster. Possible values are the following:
         * available
         * available, prep-for-resize
         * available, resize-cleanup
         * cancelling-resize
         * creating
         * deleting
         * final-snapshot
         * hardware-failure
         * incompatible-hsm
         * incompatible-network
         * incompatible-parameters
         * incompatible-restore
         * modifying
         * paused
         * rebooting
         * renaming
         * resizing
         * rotating-keys
         * storage-full
         * updating-hsm
         */
        var clusterStatus: String?
        /**
         * The name of the subnet group that is associated with the cluster. This parameter is
         * valid only when the cluster is in a VPC.
         */
        var clusterSubnetGroupName: String?
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        var clusterVersion: String?
        /**
         *
         */
        var dataTransferProgress: DataTransferProgress?
        /**
         * The name of the initial database that was created when the cluster was created.
         * This same name is returned for the life of the cluster. If an initial database was not
         * specified, a database named devdev was created by default.
         */
        var dbName: String?
        /**
         * Describes a group of DeferredMaintenanceWindow objects.
         */
        var deferredMaintenanceWindows: List<DeferredMaintenanceWindow>?
        /**
         * The status of the elastic IP (EIP) address.
         */
        var elasticIpStatus: ElasticIpStatus?
        /**
         * The number of nodes that you can resize the cluster to with the elastic resize method.
         */
        var elasticResizeNumberOfNodeOptions: String?
        /**
         * A boolean value that, if true, indicates that data in the cluster is
         * encrypted at rest.
         */
        var encrypted: Boolean
        /**
         * The connection endpoint.
         */
        var endpoint: Endpoint?
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        var enhancedVpcRouting: Boolean
        /**
         * The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled.
         */
        var expectedNextSnapshotScheduleTime: Instant?
        /**
         * The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled.  Possible values are the following:
         * OnTrack - The next snapshot is expected to be taken on time.
         * Pending - The next snapshot is pending to be taken.
         */
        var expectedNextSnapshotScheduleTimeStatus: String?
        /**
         * A value that reports whether the Amazon Redshift cluster has finished applying any
         * hardware security module (HSM) settings changes specified in a modify cluster
         * command.
         * Values: active, applying
         */
        var hsmStatus: HsmStatus?
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the
         * cluster to access other Amazon Web Services services.
         */
        var iamRoles: List<ClusterIamRole>?
        /**
         * The Key Management Service (KMS) key ID of the encryption key used to
         * encrypt data in the cluster.
         */
        var kmsKeyId: String?
        /**
         * The name of the maintenance track for the cluster.
         */
        var maintenanceTrackName: String?
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the
         * snapshot is retained indefinitely. This setting doesn't change the retention period
         * of existing snapshots.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: Int
        /**
         * The admin user name for the cluster. This name is used to connect to the database
         * that is specified in the DBName parameter.
         */
        var masterUsername: String?
        /**
         * The status of a modify operation, if any, initiated for the cluster.
         */
        var modifyStatus: String?
        /**
         * The date and time in UTC when system maintenance can begin.
         */
        var nextMaintenanceWindowStartTime: Instant?
        /**
         * The node type for the nodes in the cluster.
         */
        var nodeType: String?
        /**
         * The number of compute nodes in the cluster.
         */
        var numberOfNodes: Int
        /**
         * Cluster operations that are waiting to be started.
         */
        var pendingActions: List<String>?
        /**
         * A value that, if present, indicates that changes to the cluster are pending.
         * Specific pending changes are identified by subelements.
         */
        var pendingModifiedValues: PendingModifiedValues?
        /**
         * The weekly time range, in Universal Coordinated Time (UTC), during which system
         * maintenance can occur.
         */
        var preferredMaintenanceWindow: String?
        /**
         * A boolean value that, if true, indicates that the cluster can be
         * accessed from a public network.
         */
        var publiclyAccessible: Boolean
        /**
         * Returns the following:
         * AllowCancelResize: a boolean value indicating if the resize operation can be
         * cancelled.
         * ResizeType: Returns ClassicResize
         */
        var resizeInfo: ResizeInfo?
        /**
         * A value that describes the status of a cluster restore action. This parameter
         * returns null if the cluster was not created by restoring a snapshot.
         */
        var restoreStatus: RestoreStatus?
        /**
         * A unique identifier for the cluster snapshot schedule.
         */
        var snapshotScheduleIdentifier: String?
        /**
         * The current state of the cluster snapshot schedule.
         */
        var snapshotScheduleState: ScheduleState?
        /**
         * The list of tags for the cluster.
         */
        var tags: List<Tag>?
        /**
         * The total storage capacity of the cluster in megabytes.
         */
        var totalStorageCapacityInMegaBytes: Long?
        /**
         * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
         */
        var vpcId: String?
        /**
         * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are
         * associated with the cluster. This parameter is returned only if the cluster is in a
         * VPC.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>?

        fun build(): Cluster
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.AquaConfiguration] inside the given [block]
         */
        fun aquaConfiguration(block: AquaConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.aquaConfiguration = AquaConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus] inside the given [block]
         */
        fun clusterSnapshotCopyStatus(block: ClusterSnapshotCopyStatus.DslBuilder.() -> kotlin.Unit) {
            this.clusterSnapshotCopyStatus = ClusterSnapshotCopyStatus.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.DataTransferProgress] inside the given [block]
         */
        fun dataTransferProgress(block: DataTransferProgress.DslBuilder.() -> kotlin.Unit) {
            this.dataTransferProgress = DataTransferProgress.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ElasticIpStatus] inside the given [block]
         */
        fun elasticIpStatus(block: ElasticIpStatus.DslBuilder.() -> kotlin.Unit) {
            this.elasticIpStatus = ElasticIpStatus.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.Endpoint] inside the given [block]
         */
        fun endpoint(block: Endpoint.DslBuilder.() -> kotlin.Unit) {
            this.endpoint = Endpoint.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.HsmStatus] inside the given [block]
         */
        fun hsmStatus(block: HsmStatus.DslBuilder.() -> kotlin.Unit) {
            this.hsmStatus = HsmStatus.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.PendingModifiedValues] inside the given [block]
         */
        fun pendingModifiedValues(block: PendingModifiedValues.DslBuilder.() -> kotlin.Unit) {
            this.pendingModifiedValues = PendingModifiedValues.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ResizeInfo] inside the given [block]
         */
        fun resizeInfo(block: ResizeInfo.DslBuilder.() -> kotlin.Unit) {
            this.resizeInfo = ResizeInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.RestoreStatus] inside the given [block]
         */
        fun restoreStatus(block: RestoreStatus.DslBuilder.() -> kotlin.Unit) {
            this.restoreStatus = RestoreStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowVersionUpgrade: Boolean = false
        override var aquaConfiguration: AquaConfiguration? = null
        override var automatedSnapshotRetentionPeriod: Int = 0
        override var availabilityZone: String? = null
        override var availabilityZoneRelocationStatus: String? = null
        override var clusterAvailabilityStatus: String? = null
        override var clusterCreateTime: Instant? = null
        override var clusterIdentifier: String? = null
        override var clusterNamespaceArn: String? = null
        override var clusterNodes: List<ClusterNode>? = null
        override var clusterParameterGroups: List<ClusterParameterGroupStatus>? = null
        override var clusterPublicKey: String? = null
        override var clusterRevisionNumber: String? = null
        override var clusterSecurityGroups: List<ClusterSecurityGroupMembership>? = null
        override var clusterSnapshotCopyStatus: ClusterSnapshotCopyStatus? = null
        override var clusterStatus: String? = null
        override var clusterSubnetGroupName: String? = null
        override var clusterVersion: String? = null
        override var dataTransferProgress: DataTransferProgress? = null
        override var dbName: String? = null
        override var deferredMaintenanceWindows: List<DeferredMaintenanceWindow>? = null
        override var elasticIpStatus: ElasticIpStatus? = null
        override var elasticResizeNumberOfNodeOptions: String? = null
        override var encrypted: Boolean = false
        override var endpoint: Endpoint? = null
        override var enhancedVpcRouting: Boolean = false
        override var expectedNextSnapshotScheduleTime: Instant? = null
        override var expectedNextSnapshotScheduleTimeStatus: String? = null
        override var hsmStatus: HsmStatus? = null
        override var iamRoles: List<ClusterIamRole>? = null
        override var kmsKeyId: String? = null
        override var maintenanceTrackName: String? = null
        override var manualSnapshotRetentionPeriod: Int = 0
        override var masterUsername: String? = null
        override var modifyStatus: String? = null
        override var nextMaintenanceWindowStartTime: Instant? = null
        override var nodeType: String? = null
        override var numberOfNodes: Int = 0
        override var pendingActions: List<String>? = null
        override var pendingModifiedValues: PendingModifiedValues? = null
        override var preferredMaintenanceWindow: String? = null
        override var publiclyAccessible: Boolean = false
        override var resizeInfo: ResizeInfo? = null
        override var restoreStatus: RestoreStatus? = null
        override var snapshotScheduleIdentifier: String? = null
        override var snapshotScheduleState: ScheduleState? = null
        override var tags: List<Tag>? = null
        override var totalStorageCapacityInMegaBytes: Long? = null
        override var vpcId: String? = null
        override var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        constructor(x: Cluster) : this() {
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.aquaConfiguration = x.aquaConfiguration
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneRelocationStatus = x.availabilityZoneRelocationStatus
            this.clusterAvailabilityStatus = x.clusterAvailabilityStatus
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterNamespaceArn = x.clusterNamespaceArn
            this.clusterNodes = x.clusterNodes
            this.clusterParameterGroups = x.clusterParameterGroups
            this.clusterPublicKey = x.clusterPublicKey
            this.clusterRevisionNumber = x.clusterRevisionNumber
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterSnapshotCopyStatus = x.clusterSnapshotCopyStatus
            this.clusterStatus = x.clusterStatus
            this.clusterSubnetGroupName = x.clusterSubnetGroupName
            this.clusterVersion = x.clusterVersion
            this.dataTransferProgress = x.dataTransferProgress
            this.dbName = x.dbName
            this.deferredMaintenanceWindows = x.deferredMaintenanceWindows
            this.elasticIpStatus = x.elasticIpStatus
            this.elasticResizeNumberOfNodeOptions = x.elasticResizeNumberOfNodeOptions
            this.encrypted = x.encrypted
            this.endpoint = x.endpoint
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.expectedNextSnapshotScheduleTime = x.expectedNextSnapshotScheduleTime
            this.expectedNextSnapshotScheduleTimeStatus = x.expectedNextSnapshotScheduleTimeStatus
            this.hsmStatus = x.hsmStatus
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUsername = x.masterUsername
            this.modifyStatus = x.modifyStatus
            this.nextMaintenanceWindowStartTime = x.nextMaintenanceWindowStartTime
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.pendingActions = x.pendingActions
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.resizeInfo = x.resizeInfo
            this.restoreStatus = x.restoreStatus
            this.snapshotScheduleIdentifier = x.snapshotScheduleIdentifier
            this.snapshotScheduleState = x.snapshotScheduleState
            this.tags = x.tags
            this.totalStorageCapacityInMegaBytes = x.totalStorageCapacityInMegaBytes
            this.vpcId = x.vpcId
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        override fun build(): Cluster = Cluster(this)
        override fun allowVersionUpgrade(allowVersionUpgrade: Boolean): FluentBuilder = apply { this.allowVersionUpgrade = allowVersionUpgrade }
        override fun aquaConfiguration(aquaConfiguration: AquaConfiguration): FluentBuilder = apply { this.aquaConfiguration = aquaConfiguration }
        override fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneRelocationStatus(availabilityZoneRelocationStatus: String): FluentBuilder = apply { this.availabilityZoneRelocationStatus = availabilityZoneRelocationStatus }
        override fun clusterAvailabilityStatus(clusterAvailabilityStatus: String): FluentBuilder = apply { this.clusterAvailabilityStatus = clusterAvailabilityStatus }
        override fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder = apply { this.clusterCreateTime = clusterCreateTime }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun clusterNamespaceArn(clusterNamespaceArn: String): FluentBuilder = apply { this.clusterNamespaceArn = clusterNamespaceArn }
        override fun clusterNodes(clusterNodes: List<ClusterNode>): FluentBuilder = apply { this.clusterNodes = clusterNodes }
        override fun clusterParameterGroups(clusterParameterGroups: List<ClusterParameterGroupStatus>): FluentBuilder = apply { this.clusterParameterGroups = clusterParameterGroups }
        override fun clusterPublicKey(clusterPublicKey: String): FluentBuilder = apply { this.clusterPublicKey = clusterPublicKey }
        override fun clusterRevisionNumber(clusterRevisionNumber: String): FluentBuilder = apply { this.clusterRevisionNumber = clusterRevisionNumber }
        override fun clusterSecurityGroups(clusterSecurityGroups: List<ClusterSecurityGroupMembership>): FluentBuilder = apply { this.clusterSecurityGroups = clusterSecurityGroups }
        override fun clusterSnapshotCopyStatus(clusterSnapshotCopyStatus: ClusterSnapshotCopyStatus): FluentBuilder = apply { this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus }
        override fun clusterStatus(clusterStatus: String): FluentBuilder = apply { this.clusterStatus = clusterStatus }
        override fun clusterSubnetGroupName(clusterSubnetGroupName: String): FluentBuilder = apply { this.clusterSubnetGroupName = clusterSubnetGroupName }
        override fun clusterVersion(clusterVersion: String): FluentBuilder = apply { this.clusterVersion = clusterVersion }
        override fun dataTransferProgress(dataTransferProgress: DataTransferProgress): FluentBuilder = apply { this.dataTransferProgress = dataTransferProgress }
        override fun dbName(dbName: String): FluentBuilder = apply { this.dbName = dbName }
        override fun deferredMaintenanceWindows(deferredMaintenanceWindows: List<DeferredMaintenanceWindow>): FluentBuilder = apply { this.deferredMaintenanceWindows = deferredMaintenanceWindows }
        override fun elasticIpStatus(elasticIpStatus: ElasticIpStatus): FluentBuilder = apply { this.elasticIpStatus = elasticIpStatus }
        override fun elasticResizeNumberOfNodeOptions(elasticResizeNumberOfNodeOptions: String): FluentBuilder = apply { this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun endpoint(endpoint: Endpoint): FluentBuilder = apply { this.endpoint = endpoint }
        override fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder = apply { this.enhancedVpcRouting = enhancedVpcRouting }
        override fun expectedNextSnapshotScheduleTime(expectedNextSnapshotScheduleTime: Instant): FluentBuilder = apply { this.expectedNextSnapshotScheduleTime = expectedNextSnapshotScheduleTime }
        override fun expectedNextSnapshotScheduleTimeStatus(expectedNextSnapshotScheduleTimeStatus: String): FluentBuilder = apply { this.expectedNextSnapshotScheduleTimeStatus = expectedNextSnapshotScheduleTimeStatus }
        override fun hsmStatus(hsmStatus: HsmStatus): FluentBuilder = apply { this.hsmStatus = hsmStatus }
        override fun iamRoles(iamRoles: List<ClusterIamRole>): FluentBuilder = apply { this.iamRoles = iamRoles }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder = apply { this.maintenanceTrackName = maintenanceTrackName }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun masterUsername(masterUsername: String): FluentBuilder = apply { this.masterUsername = masterUsername }
        override fun modifyStatus(modifyStatus: String): FluentBuilder = apply { this.modifyStatus = modifyStatus }
        override fun nextMaintenanceWindowStartTime(nextMaintenanceWindowStartTime: Instant): FluentBuilder = apply { this.nextMaintenanceWindowStartTime = nextMaintenanceWindowStartTime }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun numberOfNodes(numberOfNodes: Int): FluentBuilder = apply { this.numberOfNodes = numberOfNodes }
        override fun pendingActions(pendingActions: List<String>): FluentBuilder = apply { this.pendingActions = pendingActions }
        override fun pendingModifiedValues(pendingModifiedValues: PendingModifiedValues): FluentBuilder = apply { this.pendingModifiedValues = pendingModifiedValues }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder = apply { this.publiclyAccessible = publiclyAccessible }
        override fun resizeInfo(resizeInfo: ResizeInfo): FluentBuilder = apply { this.resizeInfo = resizeInfo }
        override fun restoreStatus(restoreStatus: RestoreStatus): FluentBuilder = apply { this.restoreStatus = restoreStatus }
        override fun snapshotScheduleIdentifier(snapshotScheduleIdentifier: String): FluentBuilder = apply { this.snapshotScheduleIdentifier = snapshotScheduleIdentifier }
        override fun snapshotScheduleState(snapshotScheduleState: ScheduleState): FluentBuilder = apply { this.snapshotScheduleState = snapshotScheduleState }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun totalStorageCapacityInMegaBytes(totalStorageCapacityInMegaBytes: Long): FluentBuilder = apply { this.totalStorageCapacityInMegaBytes = totalStorageCapacityInMegaBytes }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder = apply { this.vpcSecurityGroups = vpcSecurityGroups }
    }
}
