// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the result of a cluster resize operation.
 */
class CancelResizeResponse private constructor(builder: BuilderImpl) {
    /**
     * The average rate of the resize operation over the last few minutes, measured in
     * megabytes per second. After the resize operation completes, this value shows the average
     * rate of the entire resize operation.
     */
    val avgResizeRateInMegaBytesPerSecond: Double? = builder.avgResizeRateInMegaBytesPerSecond
    /**
     * The percent of data transferred from source cluster to target cluster.
     */
    val dataTransferProgressPercent: Double? = builder.dataTransferProgressPercent
    /**
     * The amount of seconds that have elapsed since the resize operation began. After the
     * resize operation completes, this value shows the total actual time, in seconds, for the
     * resize operation.
     */
    val elapsedTimeInSeconds: Long? = builder.elapsedTimeInSeconds
    /**
     * The estimated time remaining, in seconds, until the resize operation is complete.
     * This value is calculated based on the average resize rate and the estimated amount of
     * data remaining to be processed. Once the resize operation is complete, this value will
     * be 0.
     */
    val estimatedTimeToCompletionInSeconds: Long? = builder.estimatedTimeToCompletionInSeconds
    /**
     * The names of tables that have been completely imported .
     * Valid Values: List of table names.
     */
    val importTablesCompleted: List<String>? = builder.importTablesCompleted
    /**
     * The names of tables that are being currently imported.
     * Valid Values: List of table names.
     */
    val importTablesInProgress: List<String>? = builder.importTablesInProgress
    /**
     * The names of tables that have not been yet imported.
     * Valid Values: List of table names
     */
    val importTablesNotStarted: List<String>? = builder.importTablesNotStarted
    /**
     * An optional string to provide additional details about the resize action.
     */
    val message: String? = builder.message
    /**
     * While the resize operation is in progress, this value shows the current amount of
     * data, in megabytes, that has been processed so far. When the resize operation is
     * complete, this value shows the total amount of data, in megabytes, on the cluster, which
     * may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data
     * before resize).
     */
    val progressInMegaBytes: Long? = builder.progressInMegaBytes
    /**
     * An enum with possible values of ClassicResize and
     * ElasticResize. These values describe the type of resize operation being
     * performed.
     */
    val resizeType: String? = builder.resizeType
    /**
     * The status of the resize operation.
     * Valid Values: NONE | IN_PROGRESS | FAILED |
     * SUCCEEDED | CANCELLING
     */
    val status: String? = builder.status
    /**
     * The cluster type after the resize operation is complete.
     * Valid Values: multi-node | single-node
     */
    val targetClusterType: String? = builder.targetClusterType
    /**
     * The type of encryption for the cluster after the resize is complete.
     * Possible values are KMS and None.
     */
    val targetEncryptionType: String? = builder.targetEncryptionType
    /**
     * The node type that the cluster will have after the resize operation is
     * complete.
     */
    val targetNodeType: String? = builder.targetNodeType
    /**
     * The number of nodes that the cluster will have after the resize operation is
     * complete.
     */
    val targetNumberOfNodes: Int? = builder.targetNumberOfNodes
    /**
     * The estimated total amount of data, in megabytes, on the cluster before the resize
     * operation began.
     */
    val totalResizeDataInMegaBytes: Long? = builder.totalResizeDataInMegaBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CancelResizeResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CancelResizeResponse(")
        append("avgResizeRateInMegaBytesPerSecond=$avgResizeRateInMegaBytesPerSecond,")
        append("dataTransferProgressPercent=$dataTransferProgressPercent,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedTimeToCompletionInSeconds=$estimatedTimeToCompletionInSeconds,")
        append("importTablesCompleted=$importTablesCompleted,")
        append("importTablesInProgress=$importTablesInProgress,")
        append("importTablesNotStarted=$importTablesNotStarted,")
        append("message=$message,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("resizeType=$resizeType,")
        append("status=$status,")
        append("targetClusterType=$targetClusterType,")
        append("targetEncryptionType=$targetEncryptionType,")
        append("targetNodeType=$targetNodeType,")
        append("targetNumberOfNodes=$targetNumberOfNodes,")
        append("totalResizeDataInMegaBytes=$totalResizeDataInMegaBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = avgResizeRateInMegaBytesPerSecond?.hashCode() ?: 0
        result = 31 * result + (dataTransferProgressPercent?.hashCode() ?: 0)
        result = 31 * result + (elapsedTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeToCompletionInSeconds?.hashCode() ?: 0)
        result = 31 * result + (importTablesCompleted?.hashCode() ?: 0)
        result = 31 * result + (importTablesInProgress?.hashCode() ?: 0)
        result = 31 * result + (importTablesNotStarted?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (progressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (resizeType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetClusterType?.hashCode() ?: 0)
        result = 31 * result + (targetEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (targetNodeType?.hashCode() ?: 0)
        result = 31 * result + (targetNumberOfNodes ?: 0)
        result = 31 * result + (totalResizeDataInMegaBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CancelResizeResponse

        if (avgResizeRateInMegaBytesPerSecond != other.avgResizeRateInMegaBytesPerSecond) return false
        if (dataTransferProgressPercent != other.dataTransferProgressPercent) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedTimeToCompletionInSeconds != other.estimatedTimeToCompletionInSeconds) return false
        if (importTablesCompleted != other.importTablesCompleted) return false
        if (importTablesInProgress != other.importTablesInProgress) return false
        if (importTablesNotStarted != other.importTablesNotStarted) return false
        if (message != other.message) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (resizeType != other.resizeType) return false
        if (status != other.status) return false
        if (targetClusterType != other.targetClusterType) return false
        if (targetEncryptionType != other.targetEncryptionType) return false
        if (targetNodeType != other.targetNodeType) return false
        if (targetNumberOfNodes != other.targetNumberOfNodes) return false
        if (totalResizeDataInMegaBytes != other.totalResizeDataInMegaBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CancelResizeResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CancelResizeResponse
        /**
         * The average rate of the resize operation over the last few minutes, measured in
         * megabytes per second. After the resize operation completes, this value shows the average
         * rate of the entire resize operation.
         */
        fun avgResizeRateInMegaBytesPerSecond(avgResizeRateInMegaBytesPerSecond: Double): FluentBuilder
        /**
         * The percent of data transferred from source cluster to target cluster.
         */
        fun dataTransferProgressPercent(dataTransferProgressPercent: Double): FluentBuilder
        /**
         * The amount of seconds that have elapsed since the resize operation began. After the
         * resize operation completes, this value shows the total actual time, in seconds, for the
         * resize operation.
         */
        fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder
        /**
         * The estimated time remaining, in seconds, until the resize operation is complete.
         * This value is calculated based on the average resize rate and the estimated amount of
         * data remaining to be processed. Once the resize operation is complete, this value will
         * be 0.
         */
        fun estimatedTimeToCompletionInSeconds(estimatedTimeToCompletionInSeconds: Long): FluentBuilder
        /**
         * The names of tables that have been completely imported .
         * Valid Values: List of table names.
         */
        fun importTablesCompleted(importTablesCompleted: List<String>): FluentBuilder
        /**
         * The names of tables that are being currently imported.
         * Valid Values: List of table names.
         */
        fun importTablesInProgress(importTablesInProgress: List<String>): FluentBuilder
        /**
         * The names of tables that have not been yet imported.
         * Valid Values: List of table names
         */
        fun importTablesNotStarted(importTablesNotStarted: List<String>): FluentBuilder
        /**
         * An optional string to provide additional details about the resize action.
         */
        fun message(message: String): FluentBuilder
        /**
         * While the resize operation is in progress, this value shows the current amount of
         * data, in megabytes, that has been processed so far. When the resize operation is
         * complete, this value shows the total amount of data, in megabytes, on the cluster, which
         * may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data
         * before resize).
         */
        fun progressInMegaBytes(progressInMegaBytes: Long): FluentBuilder
        /**
         * An enum with possible values of ClassicResize and
         * ElasticResize. These values describe the type of resize operation being
         * performed.
         */
        fun resizeType(resizeType: String): FluentBuilder
        /**
         * The status of the resize operation.
         * Valid Values: NONE | IN_PROGRESS | FAILED |
         * SUCCEEDED | CANCELLING
         */
        fun status(status: String): FluentBuilder
        /**
         * The cluster type after the resize operation is complete.
         * Valid Values: multi-node | single-node
         */
        fun targetClusterType(targetClusterType: String): FluentBuilder
        /**
         * The type of encryption for the cluster after the resize is complete.
         * Possible values are KMS and None.
         */
        fun targetEncryptionType(targetEncryptionType: String): FluentBuilder
        /**
         * The node type that the cluster will have after the resize operation is
         * complete.
         */
        fun targetNodeType(targetNodeType: String): FluentBuilder
        /**
         * The number of nodes that the cluster will have after the resize operation is
         * complete.
         */
        fun targetNumberOfNodes(targetNumberOfNodes: Int): FluentBuilder
        /**
         * The estimated total amount of data, in megabytes, on the cluster before the resize
         * operation began.
         */
        fun totalResizeDataInMegaBytes(totalResizeDataInMegaBytes: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The average rate of the resize operation over the last few minutes, measured in
         * megabytes per second. After the resize operation completes, this value shows the average
         * rate of the entire resize operation.
         */
        var avgResizeRateInMegaBytesPerSecond: Double?
        /**
         * The percent of data transferred from source cluster to target cluster.
         */
        var dataTransferProgressPercent: Double?
        /**
         * The amount of seconds that have elapsed since the resize operation began. After the
         * resize operation completes, this value shows the total actual time, in seconds, for the
         * resize operation.
         */
        var elapsedTimeInSeconds: Long?
        /**
         * The estimated time remaining, in seconds, until the resize operation is complete.
         * This value is calculated based on the average resize rate and the estimated amount of
         * data remaining to be processed. Once the resize operation is complete, this value will
         * be 0.
         */
        var estimatedTimeToCompletionInSeconds: Long?
        /**
         * The names of tables that have been completely imported .
         * Valid Values: List of table names.
         */
        var importTablesCompleted: List<String>?
        /**
         * The names of tables that are being currently imported.
         * Valid Values: List of table names.
         */
        var importTablesInProgress: List<String>?
        /**
         * The names of tables that have not been yet imported.
         * Valid Values: List of table names
         */
        var importTablesNotStarted: List<String>?
        /**
         * An optional string to provide additional details about the resize action.
         */
        var message: String?
        /**
         * While the resize operation is in progress, this value shows the current amount of
         * data, in megabytes, that has been processed so far. When the resize operation is
         * complete, this value shows the total amount of data, in megabytes, on the cluster, which
         * may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data
         * before resize).
         */
        var progressInMegaBytes: Long?
        /**
         * An enum with possible values of ClassicResize and
         * ElasticResize. These values describe the type of resize operation being
         * performed.
         */
        var resizeType: String?
        /**
         * The status of the resize operation.
         * Valid Values: NONE | IN_PROGRESS | FAILED |
         * SUCCEEDED | CANCELLING
         */
        var status: String?
        /**
         * The cluster type after the resize operation is complete.
         * Valid Values: multi-node | single-node
         */
        var targetClusterType: String?
        /**
         * The type of encryption for the cluster after the resize is complete.
         * Possible values are KMS and None.
         */
        var targetEncryptionType: String?
        /**
         * The node type that the cluster will have after the resize operation is
         * complete.
         */
        var targetNodeType: String?
        /**
         * The number of nodes that the cluster will have after the resize operation is
         * complete.
         */
        var targetNumberOfNodes: Int?
        /**
         * The estimated total amount of data, in megabytes, on the cluster before the resize
         * operation began.
         */
        var totalResizeDataInMegaBytes: Long?

        fun build(): CancelResizeResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var avgResizeRateInMegaBytesPerSecond: Double? = null
        override var dataTransferProgressPercent: Double? = null
        override var elapsedTimeInSeconds: Long? = null
        override var estimatedTimeToCompletionInSeconds: Long? = null
        override var importTablesCompleted: List<String>? = null
        override var importTablesInProgress: List<String>? = null
        override var importTablesNotStarted: List<String>? = null
        override var message: String? = null
        override var progressInMegaBytes: Long? = null
        override var resizeType: String? = null
        override var status: String? = null
        override var targetClusterType: String? = null
        override var targetEncryptionType: String? = null
        override var targetNodeType: String? = null
        override var targetNumberOfNodes: Int? = null
        override var totalResizeDataInMegaBytes: Long? = null

        constructor(x: CancelResizeResponse) : this() {
            this.avgResizeRateInMegaBytesPerSecond = x.avgResizeRateInMegaBytesPerSecond
            this.dataTransferProgressPercent = x.dataTransferProgressPercent
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedTimeToCompletionInSeconds = x.estimatedTimeToCompletionInSeconds
            this.importTablesCompleted = x.importTablesCompleted
            this.importTablesInProgress = x.importTablesInProgress
            this.importTablesNotStarted = x.importTablesNotStarted
            this.message = x.message
            this.progressInMegaBytes = x.progressInMegaBytes
            this.resizeType = x.resizeType
            this.status = x.status
            this.targetClusterType = x.targetClusterType
            this.targetEncryptionType = x.targetEncryptionType
            this.targetNodeType = x.targetNodeType
            this.targetNumberOfNodes = x.targetNumberOfNodes
            this.totalResizeDataInMegaBytes = x.totalResizeDataInMegaBytes
        }

        override fun build(): CancelResizeResponse = CancelResizeResponse(this)
        override fun avgResizeRateInMegaBytesPerSecond(avgResizeRateInMegaBytesPerSecond: Double): FluentBuilder = apply { this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond }
        override fun dataTransferProgressPercent(dataTransferProgressPercent: Double): FluentBuilder = apply { this.dataTransferProgressPercent = dataTransferProgressPercent }
        override fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder = apply { this.elapsedTimeInSeconds = elapsedTimeInSeconds }
        override fun estimatedTimeToCompletionInSeconds(estimatedTimeToCompletionInSeconds: Long): FluentBuilder = apply { this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds }
        override fun importTablesCompleted(importTablesCompleted: List<String>): FluentBuilder = apply { this.importTablesCompleted = importTablesCompleted }
        override fun importTablesInProgress(importTablesInProgress: List<String>): FluentBuilder = apply { this.importTablesInProgress = importTablesInProgress }
        override fun importTablesNotStarted(importTablesNotStarted: List<String>): FluentBuilder = apply { this.importTablesNotStarted = importTablesNotStarted }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun progressInMegaBytes(progressInMegaBytes: Long): FluentBuilder = apply { this.progressInMegaBytes = progressInMegaBytes }
        override fun resizeType(resizeType: String): FluentBuilder = apply { this.resizeType = resizeType }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun targetClusterType(targetClusterType: String): FluentBuilder = apply { this.targetClusterType = targetClusterType }
        override fun targetEncryptionType(targetEncryptionType: String): FluentBuilder = apply { this.targetEncryptionType = targetEncryptionType }
        override fun targetNodeType(targetNodeType: String): FluentBuilder = apply { this.targetNodeType = targetNodeType }
        override fun targetNumberOfNodes(targetNumberOfNodes: Int): FluentBuilder = apply { this.targetNumberOfNodes = targetNumberOfNodes }
        override fun totalResizeDataInMegaBytes(totalResizeDataInMegaBytes: Long): FluentBuilder = apply { this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes }
    }
}
