// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class AuthorizeSnapshotAccessRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the Amazon Web Services account authorized to restore the specified
     * snapshot.
     * To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
     */
    val accountWithRestoreAccess: String? = builder.accountWithRestoreAccess
    /**
     * The identifier of the cluster the snapshot was created from. This parameter is
     * required if your IAM user has a policy containing a snapshot resource element that
     * specifies anything other than * for the cluster name.
     */
    val snapshotClusterIdentifier: String? = builder.snapshotClusterIdentifier
    /**
     * The identifier of the snapshot the account is authorized to restore.
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AuthorizeSnapshotAccessRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizeSnapshotAccessRequest(")
        append("accountWithRestoreAccess=$accountWithRestoreAccess,")
        append("snapshotClusterIdentifier=$snapshotClusterIdentifier,")
        append("snapshotIdentifier=$snapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountWithRestoreAccess?.hashCode() ?: 0
        result = 31 * result + (snapshotClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AuthorizeSnapshotAccessRequest

        if (accountWithRestoreAccess != other.accountWithRestoreAccess) return false
        if (snapshotClusterIdentifier != other.snapshotClusterIdentifier) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AuthorizeSnapshotAccessRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AuthorizeSnapshotAccessRequest
        /**
         * The identifier of the Amazon Web Services account authorized to restore the specified
         * snapshot.
         * To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
         */
        fun accountWithRestoreAccess(accountWithRestoreAccess: String): FluentBuilder
        /**
         * The identifier of the cluster the snapshot was created from. This parameter is
         * required if your IAM user has a policy containing a snapshot resource element that
         * specifies anything other than * for the cluster name.
         */
        fun snapshotClusterIdentifier(snapshotClusterIdentifier: String): FluentBuilder
        /**
         * The identifier of the snapshot the account is authorized to restore.
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the Amazon Web Services account authorized to restore the specified
         * snapshot.
         * To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
         */
        var accountWithRestoreAccess: String?
        /**
         * The identifier of the cluster the snapshot was created from. This parameter is
         * required if your IAM user has a policy containing a snapshot resource element that
         * specifies anything other than * for the cluster name.
         */
        var snapshotClusterIdentifier: String?
        /**
         * The identifier of the snapshot the account is authorized to restore.
         */
        var snapshotIdentifier: String?

        fun build(): AuthorizeSnapshotAccessRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountWithRestoreAccess: String? = null
        override var snapshotClusterIdentifier: String? = null
        override var snapshotIdentifier: String? = null

        constructor(x: AuthorizeSnapshotAccessRequest) : this() {
            this.accountWithRestoreAccess = x.accountWithRestoreAccess
            this.snapshotClusterIdentifier = x.snapshotClusterIdentifier
            this.snapshotIdentifier = x.snapshotIdentifier
        }

        override fun build(): AuthorizeSnapshotAccessRequest = AuthorizeSnapshotAccessRequest(this)
        override fun accountWithRestoreAccess(accountWithRestoreAccess: String): FluentBuilder = apply { this.accountWithRestoreAccess = accountWithRestoreAccess }
        override fun snapshotClusterIdentifier(snapshotClusterIdentifier: String): FluentBuilder = apply { this.snapshotClusterIdentifier = snapshotClusterIdentifier }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
    }
}
