// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.EnableLoggingResponse
import aws.sdk.kotlin.services.redshift.model.LogDestinationType
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class EnableLoggingOperationDeserializer: HttpDeserialize<EnableLoggingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): EnableLoggingResponse {
        if (!response.status.isSuccess()) {
            throwEnableLoggingError(context, response)
        }
        val builder = EnableLoggingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeEnableLoggingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwEnableLoggingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BucketNotFoundFault" -> BucketNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientS3BucketPolicyFault" -> InsufficientS3BucketPolicyFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidS3BucketNameFault" -> InvalidS3BucketNameFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidS3KeyPrefixFault" -> InvalidS3KeyPrefixFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEnableLoggingOperationBody(builder: EnableLoggingResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("EnableLoggingResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("EnableLoggingResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap EnableLogging response")
    }
    // end unwrap response wrapper

    val BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("BucketName"))
    val LASTFAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("LastFailureMessage"))
    val LASTFAILURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("LastFailureTime"))
    val LASTSUCCESSFULDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("LastSuccessfulDeliveryTime"))
    val LOGDESTINATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("LogDestinationType"))
    val LOGEXPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("LogExports"))
    val LOGGINGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("LoggingEnabled"))
    val S3KEYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("S3KeyPrefix"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("EnableLoggingResult"))
        field(BUCKETNAME_DESCRIPTOR)
        field(LASTFAILUREMESSAGE_DESCRIPTOR)
        field(LASTFAILURETIME_DESCRIPTOR)
        field(LASTSUCCESSFULDELIVERYTIME_DESCRIPTOR)
        field(LOGDESTINATIONTYPE_DESCRIPTOR)
        field(LOGEXPORTS_DESCRIPTOR)
        field(LOGGINGENABLED_DESCRIPTOR)
        field(S3KEYPREFIX_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUCKETNAME_DESCRIPTOR.index -> builder.bucketName = deserializeString()
                LASTFAILUREMESSAGE_DESCRIPTOR.index -> builder.lastFailureMessage = deserializeString()
                LASTFAILURETIME_DESCRIPTOR.index -> builder.lastFailureTime = deserializeString().let { Instant.fromIso8601(it) }
                LASTSUCCESSFULDELIVERYTIME_DESCRIPTOR.index -> builder.lastSuccessfulDeliveryTime = deserializeString().let { Instant.fromIso8601(it) }
                LOGDESTINATIONTYPE_DESCRIPTOR.index -> builder.logDestinationType = deserializeString().let { LogDestinationType.fromValue(it) }
                LOGEXPORTS_DESCRIPTOR.index -> builder.logExports =
                    deserializer.deserializeList(LOGEXPORTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LOGGINGENABLED_DESCRIPTOR.index -> builder.loggingEnabled = deserializeBoolean()
                S3KEYPREFIX_DESCRIPTOR.index -> builder.s3KeyPrefix = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
