// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Snapshot
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateClusterSnapshotOperationDeserializer: HttpDeserialize<CreateClusterSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateClusterSnapshotResponse {
        if (!response.status.isSuccess()) {
            throwCreateClusterSnapshotError(context, response)
        }
        val builder = CreateClusterSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateClusterSnapshotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateClusterSnapshotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSnapshotAlreadyExists" -> ClusterSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSnapshotQuotaExceeded" -> ClusterSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidRetentionPeriodFault" -> InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedResponse)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterSnapshotOperationBody(builder: CreateClusterSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateClusterSnapshotResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateClusterSnapshotResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateClusterSnapshot response")
    }
    // end unwrap response wrapper

    val SNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Snapshot"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("CreateClusterSnapshotResult"))
        field(SNAPSHOT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SNAPSHOT_DESCRIPTOR.index -> builder.snapshot = deserializeSnapshotDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
