// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.AuthorizationStatus
import aws.sdk.kotlin.services.redshift.model.AuthorizeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class AuthorizeEndpointAccessOperationDeserializer: HttpDeserialize<AuthorizeEndpointAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AuthorizeEndpointAccessResponse {
        if (!response.status.isSuccess()) {
            throwAuthorizeEndpointAccessError(context, response)
        }
        val builder = AuthorizeEndpointAccessResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAuthorizeEndpointAccessOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAuthorizeEndpointAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "EndpointAuthorizationAlreadyExists" -> EndpointAuthorizationAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "EndpointAuthorizationsPerClusterLimitExceeded" -> EndpointAuthorizationsPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidAuthorizationState" -> InvalidAuthorizationStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAuthorizeEndpointAccessOperationBody(builder: AuthorizeEndpointAccessResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AuthorizeEndpointAccessResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("AuthorizeEndpointAccessResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap AuthorizeEndpointAccess response")
    }
    // end unwrap response wrapper

    val ALLOWEDALLVPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("AllowedAllVPCs"))
    val ALLOWEDVPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AllowedVPCs"), XmlCollectionName("VpcIdentifier"))
    val AUTHORIZETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("AuthorizeTime"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterIdentifier"))
    val CLUSTERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterStatus"))
    val ENDPOINTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("EndpointCount"))
    val GRANTEE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Grantee"))
    val GRANTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Grantor"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("AuthorizeEndpointAccessResult"))
        field(ALLOWEDALLVPCS_DESCRIPTOR)
        field(ALLOWEDVPCS_DESCRIPTOR)
        field(AUTHORIZETIME_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CLUSTERSTATUS_DESCRIPTOR)
        field(ENDPOINTCOUNT_DESCRIPTOR)
        field(GRANTEE_DESCRIPTOR)
        field(GRANTOR_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWEDALLVPCS_DESCRIPTOR.index -> builder.allowedAllVpCs = deserializeBoolean()
                ALLOWEDVPCS_DESCRIPTOR.index -> builder.allowedVpCs =
                    deserializer.deserializeList(ALLOWEDVPCS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHORIZETIME_DESCRIPTOR.index -> builder.authorizeTime = deserializeString().let { Instant.fromIso8601(it) }
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CLUSTERSTATUS_DESCRIPTOR.index -> builder.clusterStatus = deserializeString()
                ENDPOINTCOUNT_DESCRIPTOR.index -> builder.endpointCount = deserializeInt()
                GRANTEE_DESCRIPTOR.index -> builder.grantee = deserializeString()
                GRANTOR_DESCRIPTOR.index -> builder.grantor = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AuthorizationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
