// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.
 */
public class HsmClientCertificate private constructor(builder: Builder) {
    /**
     * The identifier of the HSM client certificate.
     */
    public val hsmClientCertificateIdentifier: kotlin.String? = builder.hsmClientCertificateIdentifier
    /**
     * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.
     */
    public val hsmClientCertificatePublicKey: kotlin.String? = builder.hsmClientCertificatePublicKey
    /**
     * The list of tags for the HSM client certificate.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.HsmClientCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HsmClientCertificate(")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmClientCertificatePublicKey=$hsmClientCertificatePublicKey,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hsmClientCertificateIdentifier?.hashCode() ?: 0
        result = 31 * result + (hsmClientCertificatePublicKey?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HsmClientCertificate

        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmClientCertificatePublicKey != other.hsmClientCertificatePublicKey) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.HsmClientCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the HSM client certificate.
         */
        public var hsmClientCertificateIdentifier: kotlin.String? = null
        /**
         * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.
         */
        public var hsmClientCertificatePublicKey: kotlin.String? = null
        /**
         * The list of tags for the HSM client certificate.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.HsmClientCertificate) : this() {
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmClientCertificatePublicKey = x.hsmClientCertificatePublicKey
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.HsmClientCertificate = HsmClientCertificate(this)
    }
}
