// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.waiters

import aws.sdk.kotlin.services.redshift.RedshiftClient
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClustersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClustersResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun RedshiftClient.waitUntilClusterAvailable(request: DescribeClustersRequest = DescribeClustersRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeClustersResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeClustersRequest, DescribeClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val clusters = it.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible()
            val projection = clustersOrEmpty?.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible()
            val projection = clustersOrEmpty?.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ClusterNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusters(request) }
}

public suspend fun RedshiftClient.waitUntilClusterAvailable(block: DescribeClustersRequest.Builder.() -> Unit): Outcome<DescribeClustersResponse> =
    waitUntilClusterAvailable(DescribeClustersRequest.Builder().apply(block).build())

public suspend fun RedshiftClient.waitUntilClusterDeleted(request: DescribeClustersRequest = DescribeClustersRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeClustersResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeClustersRequest, DescribeClustersResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ClusterNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible()
            val projection = clustersOrEmpty?.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            (projection as List<String?>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible()
            val projection = clustersOrEmpty?.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            (projection as List<String?>?)?.any { it == "modifying" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusters(request) }
}

public suspend fun RedshiftClient.waitUntilClusterDeleted(block: DescribeClustersRequest.Builder.() -> Unit): Outcome<DescribeClustersResponse> =
    waitUntilClusterDeleted(DescribeClustersRequest.Builder().apply(block).build())

public suspend fun RedshiftClient.waitUntilClusterRestored(request: DescribeClustersRequest = DescribeClustersRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeClustersResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeClustersRequest, DescribeClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val clusters = it.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible()
            val projection = clustersOrEmpty?.flatMap {
                val restoreStatus = it?.restoreStatus
                val status = restoreStatus?.status
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "completed" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val clusters = it.clusters
            val clustersOrEmpty = clusters?.flattenIfPossible()
            val projection = clustersOrEmpty?.flatMap {
                val clusterStatus = it?.clusterStatus
                listOfNotNull(clusterStatus)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusters(request) }
}

public suspend fun RedshiftClient.waitUntilClusterRestored(block: DescribeClustersRequest.Builder.() -> Unit): Outcome<DescribeClustersResponse> =
    waitUntilClusterRestored(DescribeClustersRequest.Builder().apply(block).build())

public suspend fun RedshiftClient.waitUntilSnapshotAvailable(request: DescribeClusterSnapshotsRequest = DescribeClusterSnapshotsRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeClusterSnapshotsResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val snapshots = it.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible()
            val projection = snapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val snapshots = it.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible()
            val projection = snapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val snapshots = it.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible()
            val projection = snapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeClusterSnapshots(request) }
}

public suspend fun RedshiftClient.waitUntilSnapshotAvailable(block: DescribeClusterSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeClusterSnapshotsResponse> =
    waitUntilSnapshotAvailable(DescribeClusterSnapshotsRequest.Builder().apply(block).build())
