// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ReservedNode
import aws.sdk.kotlin.services.redshift.model.ReservedNodeOfferingType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeReservedNodeDocument(reader: XmlTagReader): ReservedNode {
    val builder = ReservedNode.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReservedNodeId com.amazonaws.redshift#ReservedNode$ReservedNodeId
            "ReservedNodeId" -> builder.reservedNodeId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ReservedNodeOfferingId com.amazonaws.redshift#ReservedNode$ReservedNodeOfferingId
            "ReservedNodeOfferingId" -> builder.reservedNodeOfferingId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NodeType com.amazonaws.redshift#ReservedNode$NodeType
            "NodeType" -> builder.nodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // StartTime com.amazonaws.redshift#ReservedNode$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // Duration com.amazonaws.redshift#ReservedNode$Duration
            "Duration" -> builder.duration = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // FixedPrice com.amazonaws.redshift#ReservedNode$FixedPrice
            "FixedPrice" -> builder.fixedPrice = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#Double`)" }
            // UsagePrice com.amazonaws.redshift#ReservedNode$UsagePrice
            "UsagePrice" -> builder.usagePrice = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#Double`)" }
            // CurrencyCode com.amazonaws.redshift#ReservedNode$CurrencyCode
            "CurrencyCode" -> builder.currencyCode = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NodeCount com.amazonaws.redshift#ReservedNode$NodeCount
            "NodeCount" -> builder.nodeCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // State com.amazonaws.redshift#ReservedNode$State
            "State" -> builder.state = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // OfferingType com.amazonaws.redshift#ReservedNode$OfferingType
            "OfferingType" -> builder.offeringType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // RecurringCharges com.amazonaws.redshift#ReservedNode$RecurringCharges
            "RecurringCharges" -> builder.recurringCharges = deserializeRecurringChargeListShape(curr)
            // ReservedNodeOfferingType com.amazonaws.redshift#ReservedNode$ReservedNodeOfferingType
            "ReservedNodeOfferingType" -> builder.reservedNodeOfferingType = curr.tryData()
                .parse { ReservedNodeOfferingType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ReservedNodeOfferingType`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
