// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ImpactRankingType
import aws.sdk.kotlin.services.redshift.model.Recommendation
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeRecommendationDocument(reader: XmlTagReader): Recommendation {
    val builder = Recommendation.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.redshift#Recommendation$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterIdentifier com.amazonaws.redshift#Recommendation$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NamespaceArn com.amazonaws.redshift#Recommendation$NamespaceArn
            "NamespaceArn" -> builder.namespaceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CreatedAt com.amazonaws.redshift#Recommendation$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // RecommendationType com.amazonaws.redshift#Recommendation$RecommendationType
            "RecommendationType" -> builder.recommendationType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Title com.amazonaws.redshift#Recommendation$Title
            "Title" -> builder.title = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Description com.amazonaws.redshift#Recommendation$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Observation com.amazonaws.redshift#Recommendation$Observation
            "Observation" -> builder.observation = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ImpactRanking com.amazonaws.redshift#Recommendation$ImpactRanking
            "ImpactRanking" -> builder.impactRanking = curr.tryData()
                .parse { ImpactRankingType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ImpactRankingType`)" }
            // RecommendationText com.amazonaws.redshift#Recommendation$RecommendationText
            "RecommendationText" -> builder.recommendationText = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // RecommendedActions com.amazonaws.redshift#Recommendation$RecommendedActions
            "RecommendedActions" -> builder.recommendedActions = deserializeRecommendedActionListShape(curr)
            // ReferenceLinks com.amazonaws.redshift#Recommendation$ReferenceLinks
            "ReferenceLinks" -> builder.referenceLinks = deserializeReferenceLinkListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
