// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Integration
import aws.sdk.kotlin.services.redshift.model.ZeroEtlIntegrationStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeIntegrationDocument(reader: XmlTagReader): Integration {
    val builder = Integration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // IntegrationArn com.amazonaws.redshift#Integration$IntegrationArn
            "IntegrationArn" -> builder.integrationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#IntegrationArn`)" }
            // IntegrationName com.amazonaws.redshift#Integration$IntegrationName
            "IntegrationName" -> builder.integrationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#IntegrationName`)" }
            // SourceArn com.amazonaws.redshift#Integration$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#SourceArn`)" }
            // TargetArn com.amazonaws.redshift#Integration$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#TargetArn`)" }
            // Status com.amazonaws.redshift#Integration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ZeroEtlIntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ZeroETLIntegrationStatus`)" }
            // Errors com.amazonaws.redshift#Integration$Errors
            "Errors" -> builder.errors = deserializeIntegrationErrorListShape(curr)
            // CreateTime com.amazonaws.redshift#Integration$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // Description com.amazonaws.redshift#Integration$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#Description`)" }
            // KMSKeyId com.amazonaws.redshift#Integration$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // AdditionalEncryptionContext com.amazonaws.redshift#Integration$AdditionalEncryptionContext
            "AdditionalEncryptionContext" -> builder.additionalEncryptionContext = deserializeEncryptionContextMapShape(curr)
            // Tags com.amazonaws.redshift#Integration$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
