// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.EndpointAccess
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEndpointAccessDocument(reader: XmlTagReader): EndpointAccess {
    val builder = EndpointAccess.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterIdentifier com.amazonaws.redshift#EndpointAccess$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ResourceOwner com.amazonaws.redshift#EndpointAccess$ResourceOwner
            "ResourceOwner" -> builder.resourceOwner = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SubnetGroupName com.amazonaws.redshift#EndpointAccess$SubnetGroupName
            "SubnetGroupName" -> builder.subnetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EndpointStatus com.amazonaws.redshift#EndpointAccess$EndpointStatus
            "EndpointStatus" -> builder.endpointStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EndpointName com.amazonaws.redshift#EndpointAccess$EndpointName
            "EndpointName" -> builder.endpointName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EndpointCreateTime com.amazonaws.redshift#EndpointAccess$EndpointCreateTime
            "EndpointCreateTime" -> builder.endpointCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // Port com.amazonaws.redshift#EndpointAccess$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // Address com.amazonaws.redshift#EndpointAccess$Address
            "Address" -> builder.address = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // VpcSecurityGroups com.amazonaws.redshift#EndpointAccess$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            // VpcEndpoint com.amazonaws.redshift#EndpointAccess$VpcEndpoint
            "VpcEndpoint" -> builder.vpcEndpoint = deserializeVpcEndpointDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
