// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.DataShareAssociation
import aws.sdk.kotlin.services.redshift.model.DataShareType
import aws.sdk.kotlin.services.redshift.model.DisassociateDataShareConsumerResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DisassociateDataShareConsumerOperationDeserializer: HttpDeserializer.NonStreaming<DisassociateDataShareConsumerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DisassociateDataShareConsumerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDisassociateDataShareConsumerError(context, call, payload)
        }
        val builder = DisassociateDataShareConsumerResponse.Builder()

        if (payload != null) {
            deserializeDisassociateDataShareConsumerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDisassociateDataShareConsumerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDataShareFault" -> InvalidDataShareFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNamespaceFault" -> InvalidNamespaceFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisassociateDataShareConsumerOperationBody(builder: DisassociateDataShareConsumerResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DisassociateDataShareConsumer")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AllowPubliclyAccessibleConsumers com.amazonaws.redshift#DataShare$AllowPubliclyAccessibleConsumers
            "AllowPubliclyAccessibleConsumers" -> builder.allowPubliclyAccessibleConsumers = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // DataShareArn com.amazonaws.redshift#DataShare$DataShareArn
            "DataShareArn" -> builder.dataShareArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // DataShareAssociations com.amazonaws.redshift#DataShare$DataShareAssociations
            "DataShareAssociations" -> builder.dataShareAssociations = deserializeDataShareAssociationListShape(curr)
            // DataShareType com.amazonaws.redshift#DataShare$DataShareType
            "DataShareType" -> builder.dataShareType = curr.tryData()
                .parse { DataShareType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#DataShareType`)" }
            // ManagedBy com.amazonaws.redshift#DataShare$ManagedBy
            "ManagedBy" -> builder.managedBy = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ProducerArn com.amazonaws.redshift#DataShare$ProducerArn
            "ProducerArn" -> builder.producerArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
