// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateIntegrationResponse
import aws.sdk.kotlin.services.redshift.model.IntegrationError
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Tag
import aws.sdk.kotlin.services.redshift.model.ZeroEtlIntegrationStatus
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateIntegrationOperationDeserializer: HttpDeserializer.NonStreaming<CreateIntegrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateIntegrationError(context, call, payload)
        }
        val builder = CreateIntegrationResponse.Builder()

        if (payload != null) {
            deserializeCreateIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateIntegrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "IntegrationTargetNotFoundFault" -> IntegrationTargetNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationAlreadyExistsFault" -> IntegrationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationConflictOperationFault" -> IntegrationConflictOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationQuotaExceededFault" -> IntegrationQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationSourceNotFoundFault" -> IntegrationSourceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIntegrationOperationBody(builder: CreateIntegrationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateIntegration")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AdditionalEncryptionContext com.amazonaws.redshift#Integration$AdditionalEncryptionContext
            "AdditionalEncryptionContext" -> builder.additionalEncryptionContext = deserializeEncryptionContextMapShape(curr)
            // CreateTime com.amazonaws.redshift#Integration$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // Description com.amazonaws.redshift#Integration$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#Description`)" }
            // Errors com.amazonaws.redshift#Integration$Errors
            "Errors" -> builder.errors = deserializeIntegrationErrorListShape(curr)
            // IntegrationArn com.amazonaws.redshift#Integration$IntegrationArn
            "IntegrationArn" -> builder.integrationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#IntegrationArn`)" }
            // IntegrationName com.amazonaws.redshift#Integration$IntegrationName
            "IntegrationName" -> builder.integrationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#IntegrationName`)" }
            // KMSKeyId com.amazonaws.redshift#Integration$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceArn com.amazonaws.redshift#Integration$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#SourceArn`)" }
            // Status com.amazonaws.redshift#Integration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ZeroEtlIntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ZeroETLIntegrationStatus`)" }
            // Tags com.amazonaws.redshift#Integration$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // TargetArn com.amazonaws.redshift#Integration$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#TargetArn`)" }
            else -> {}
        }
        curr.drop()
    }
}
