// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterSubnetGroup
import aws.sdk.kotlin.services.redshift.model.CreateClusterSubnetGroupResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateClusterSubnetGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateClusterSubnetGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateClusterSubnetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterSubnetGroupError(context, call, payload)
        }
        val builder = CreateClusterSubnetGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateClusterSubnetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateClusterSubnetGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSubnetGroupAlreadyExists" -> ClusterSubnetGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSubnetQuotaExceededFault" -> ClusterSubnetQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSubnetGroupQuotaExceeded" -> ClusterSubnetGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterSubnetGroupOperationBody(builder: CreateClusterSubnetGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateClusterSubnetGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterSubnetGroup com.amazonaws.redshift#CreateClusterSubnetGroupResult$ClusterSubnetGroup
            "ClusterSubnetGroup" -> builder.clusterSubnetGroup = deserializeClusterSubnetGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
