// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.CreateClusterResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateClusterOperationDeserializer: HttpDeserializer.NonStreaming<CreateClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterError(context, call, payload)
        }
        val builder = CreateClusterResponse.Builder()

        if (payload != null) {
            deserializeCreateClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterQuotaExceeded" -> ClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "HsmConfigurationNotFoundFault" -> HsmConfigurationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NumberOfNodesQuotaExceeded" -> NumberOfNodesQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        "HsmClientCertificateNotFoundFault" -> HsmClientCertificateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterSubnetGroupStateFault" -> InvalidClusterSubnetGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSecurityGroupNotFound" -> ClusterSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterAlreadyExists" -> ClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterParameterGroupNotFound" -> ClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSubnetGroupNotFoundFault" -> ClusterSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "Ipv6CidrBlockNotFoundFault" -> Ipv6CidrBlockNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "RedshiftIdcApplicationNotExists" -> RedshiftIdcApplicationNotExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientClusterCapacity" -> InsufficientClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterTrack" -> InvalidClusterTrackFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidElasticIpFault" -> InvalidElasticIpFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRetentionPeriodFault" -> InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NumberOfNodesPerClusterLimitExceeded" -> NumberOfNodesPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterOperationBody(builder: CreateClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Cluster com.amazonaws.redshift#CreateClusterResult$Cluster
            "Cluster" -> builder.cluster = deserializeClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
