// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains properties for the Redshift IDC application.
 */
public class RedshiftIdcApplication private constructor(builder: Builder) {
    /**
     * The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
     */
    public val authorizedTokenIssuerList: List<AuthorizedTokenIssuer>? = builder.authorizedTokenIssuerList
    /**
     * The ARN for the Amazon Redshift IAM Identity Center application. It has the required permissions to be assumed and invoke the IDC Identity Center API.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The display name for the Amazon Redshift IAM Identity Center application. It appears on the console.
     */
    public val idcDisplayName: kotlin.String? = builder.idcDisplayName
    /**
     * The ARN for the IAM Identity Center instance that Redshift integrates with.
     */
    public val idcInstanceArn: kotlin.String? = builder.idcInstanceArn
    /**
     * The ARN for the Amazon Redshift IAM Identity Center application.
     */
    public val idcManagedApplicationArn: kotlin.String? = builder.idcManagedApplicationArn
    /**
     * The onboarding status for the Amazon Redshift IAM Identity Center application.
     */
    public val idcOnboardStatus: kotlin.String? = builder.idcOnboardStatus
    /**
     * The identity namespace for the Amazon Redshift IAM Identity Center application. It determines which managed application verifies the connection token.
     */
    public val identityNamespace: kotlin.String? = builder.identityNamespace
    /**
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     */
    public val redshiftIdcApplicationArn: kotlin.String? = builder.redshiftIdcApplicationArn
    /**
     * The name of the Redshift application in IAM Identity Center.
     */
    public val redshiftIdcApplicationName: kotlin.String? = builder.redshiftIdcApplicationName
    /**
     * A list of service integrations for the Redshift IAM Identity Center application.
     */
    public val serviceIntegrations: List<ServiceIntegrationsUnion>? = builder.serviceIntegrations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.RedshiftIdcApplication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftIdcApplication(")
        append("authorizedTokenIssuerList=$authorizedTokenIssuerList,")
        append("iamRoleArn=$iamRoleArn,")
        append("idcDisplayName=$idcDisplayName,")
        append("idcInstanceArn=$idcInstanceArn,")
        append("idcManagedApplicationArn=$idcManagedApplicationArn,")
        append("idcOnboardStatus=$idcOnboardStatus,")
        append("identityNamespace=$identityNamespace,")
        append("redshiftIdcApplicationArn=$redshiftIdcApplicationArn,")
        append("redshiftIdcApplicationName=$redshiftIdcApplicationName,")
        append("serviceIntegrations=$serviceIntegrations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizedTokenIssuerList?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (idcDisplayName?.hashCode() ?: 0)
        result = 31 * result + (idcInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (idcManagedApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (idcOnboardStatus?.hashCode() ?: 0)
        result = 31 * result + (identityNamespace?.hashCode() ?: 0)
        result = 31 * result + (redshiftIdcApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (redshiftIdcApplicationName?.hashCode() ?: 0)
        result = 31 * result + (serviceIntegrations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftIdcApplication

        if (authorizedTokenIssuerList != other.authorizedTokenIssuerList) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (idcDisplayName != other.idcDisplayName) return false
        if (idcInstanceArn != other.idcInstanceArn) return false
        if (idcManagedApplicationArn != other.idcManagedApplicationArn) return false
        if (idcOnboardStatus != other.idcOnboardStatus) return false
        if (identityNamespace != other.identityNamespace) return false
        if (redshiftIdcApplicationArn != other.redshiftIdcApplicationArn) return false
        if (redshiftIdcApplicationName != other.redshiftIdcApplicationName) return false
        if (serviceIntegrations != other.serviceIntegrations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.RedshiftIdcApplication = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
         */
        public var authorizedTokenIssuerList: List<AuthorizedTokenIssuer>? = null
        /**
         * The ARN for the Amazon Redshift IAM Identity Center application. It has the required permissions to be assumed and invoke the IDC Identity Center API.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The display name for the Amazon Redshift IAM Identity Center application. It appears on the console.
         */
        public var idcDisplayName: kotlin.String? = null
        /**
         * The ARN for the IAM Identity Center instance that Redshift integrates with.
         */
        public var idcInstanceArn: kotlin.String? = null
        /**
         * The ARN for the Amazon Redshift IAM Identity Center application.
         */
        public var idcManagedApplicationArn: kotlin.String? = null
        /**
         * The onboarding status for the Amazon Redshift IAM Identity Center application.
         */
        public var idcOnboardStatus: kotlin.String? = null
        /**
         * The identity namespace for the Amazon Redshift IAM Identity Center application. It determines which managed application verifies the connection token.
         */
        public var identityNamespace: kotlin.String? = null
        /**
         * The ARN for the Redshift application that integrates with IAM Identity Center.
         */
        public var redshiftIdcApplicationArn: kotlin.String? = null
        /**
         * The name of the Redshift application in IAM Identity Center.
         */
        public var redshiftIdcApplicationName: kotlin.String? = null
        /**
         * A list of service integrations for the Redshift IAM Identity Center application.
         */
        public var serviceIntegrations: List<ServiceIntegrationsUnion>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.RedshiftIdcApplication) : this() {
            this.authorizedTokenIssuerList = x.authorizedTokenIssuerList
            this.iamRoleArn = x.iamRoleArn
            this.idcDisplayName = x.idcDisplayName
            this.idcInstanceArn = x.idcInstanceArn
            this.idcManagedApplicationArn = x.idcManagedApplicationArn
            this.idcOnboardStatus = x.idcOnboardStatus
            this.identityNamespace = x.identityNamespace
            this.redshiftIdcApplicationArn = x.redshiftIdcApplicationArn
            this.redshiftIdcApplicationName = x.redshiftIdcApplicationName
            this.serviceIntegrations = x.serviceIntegrations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.RedshiftIdcApplication = RedshiftIdcApplication(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
