// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateIntegrationResponse private constructor(builder: Builder) {
    /**
     * The encryption context for the integration. For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Amazon Web Services Key Management Service Developer Guide*.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * The time (UTC) when the integration was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The description of the integration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Any errors associated with the integration.
     */
    public val errors: List<IntegrationError>? = builder.errors
    /**
     * The Amazon Resource Name (ARN) of the integration.
     */
    public val integrationArn: kotlin.String? = builder.integrationArn
    /**
     * The name of the integration.
     */
    public val integrationName: kotlin.String? = builder.integrationName
    /**
     * The Key Management Service (KMS) key identifier for the key used to encrypt the integration.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the database used as the source for replication.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The current status of the integration.
     */
    public val status: aws.sdk.kotlin.services.redshift.model.ZeroEtlIntegrationStatus? = builder.status
    /**
     * The list of tags associated with the integration.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to use as the target for replication.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateIntegrationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIntegrationResponse(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("errors=$errors,")
        append("integrationArn=$integrationArn,")
        append("integrationName=$integrationName,")
        append("kmsKeyId=$kmsKeyId,")
        append("sourceArn=$sourceArn,")
        append("status=$status,")
        append("tags=$tags,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (integrationArn?.hashCode() ?: 0)
        result = 31 * result + (integrationName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIntegrationResponse

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (errors != other.errors) return false
        if (integrationArn != other.integrationArn) return false
        if (integrationName != other.integrationName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (sourceArn != other.sourceArn) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateIntegrationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The encryption context for the integration. For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Amazon Web Services Key Management Service Developer Guide*.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * The time (UTC) when the integration was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the integration.
         */
        public var description: kotlin.String? = null
        /**
         * Any errors associated with the integration.
         */
        public var errors: List<IntegrationError>? = null
        /**
         * The Amazon Resource Name (ARN) of the integration.
         */
        public var integrationArn: kotlin.String? = null
        /**
         * The name of the integration.
         */
        public var integrationName: kotlin.String? = null
        /**
         * The Key Management Service (KMS) key identifier for the key used to encrypt the integration.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the database used as the source for replication.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The current status of the integration.
         */
        public var status: aws.sdk.kotlin.services.redshift.model.ZeroEtlIntegrationStatus? = null
        /**
         * The list of tags associated with the integration.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to use as the target for replication.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateIntegrationResponse) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.createTime = x.createTime
            this.description = x.description
            this.errors = x.errors
            this.integrationArn = x.integrationArn
            this.integrationName = x.integrationName
            this.kmsKeyId = x.kmsKeyId
            this.sourceArn = x.sourceArn
            this.status = x.status
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateIntegrationResponse = CreateIntegrationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
