// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the result of a cluster resize operation.
 */
public class CancelResizeResponse private constructor(builder: Builder) {
    /**
     * The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.
     */
    public val avgResizeRateInMegaBytesPerSecond: kotlin.Double? = builder.avgResizeRateInMegaBytesPerSecond
    /**
     * The percent of data transferred from source cluster to target cluster.
     */
    public val dataTransferProgressPercent: kotlin.Double? = builder.dataTransferProgressPercent
    /**
     * The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.
     */
    public val elapsedTimeInSeconds: kotlin.Long? = builder.elapsedTimeInSeconds
    /**
     * The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.
     */
    public val estimatedTimeToCompletionInSeconds: kotlin.Long? = builder.estimatedTimeToCompletionInSeconds
    /**
     * The names of tables that have been completely imported .
     *
     * Valid Values: List of table names.
     */
    public val importTablesCompleted: List<String>? = builder.importTablesCompleted
    /**
     * The names of tables that are being currently imported.
     *
     * Valid Values: List of table names.
     */
    public val importTablesInProgress: List<String>? = builder.importTablesInProgress
    /**
     * The names of tables that have not been yet imported.
     *
     * Valid Values: List of table names
     */
    public val importTablesNotStarted: List<String>? = builder.importTablesNotStarted
    /**
     * An optional string to provide additional details about the resize action.
     */
    public val message: kotlin.String? = builder.message
    /**
     * While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).
     */
    public val progressInMegaBytes: kotlin.Long? = builder.progressInMegaBytes
    /**
     * An enum with possible values of `ClassicResize` and `ElasticResize`. These values describe the type of resize operation being performed.
     */
    public val resizeType: kotlin.String? = builder.resizeType
    /**
     * The status of the resize operation.
     *
     * Valid Values: `NONE` | `IN_PROGRESS` | `FAILED` | `SUCCEEDED` | `CANCELLING`
     */
    public val status: kotlin.String? = builder.status
    /**
     * The cluster type after the resize operation is complete.
     *
     * Valid Values: `multi-node` | `single-node`
     */
    public val targetClusterType: kotlin.String? = builder.targetClusterType
    /**
     * The type of encryption for the cluster after the resize is complete.
     *
     * Possible values are `KMS` and `None`.
     */
    public val targetEncryptionType: kotlin.String? = builder.targetEncryptionType
    /**
     * The node type that the cluster will have after the resize operation is complete.
     */
    public val targetNodeType: kotlin.String? = builder.targetNodeType
    /**
     * The number of nodes that the cluster will have after the resize operation is complete.
     */
    public val targetNumberOfNodes: kotlin.Int? = builder.targetNumberOfNodes
    /**
     * The estimated total amount of data, in megabytes, on the cluster before the resize operation began.
     */
    public val totalResizeDataInMegaBytes: kotlin.Long? = builder.totalResizeDataInMegaBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CancelResizeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CancelResizeResponse(")
        append("avgResizeRateInMegaBytesPerSecond=$avgResizeRateInMegaBytesPerSecond,")
        append("dataTransferProgressPercent=$dataTransferProgressPercent,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedTimeToCompletionInSeconds=$estimatedTimeToCompletionInSeconds,")
        append("importTablesCompleted=$importTablesCompleted,")
        append("importTablesInProgress=$importTablesInProgress,")
        append("importTablesNotStarted=$importTablesNotStarted,")
        append("message=$message,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("resizeType=$resizeType,")
        append("status=$status,")
        append("targetClusterType=$targetClusterType,")
        append("targetEncryptionType=$targetEncryptionType,")
        append("targetNodeType=$targetNodeType,")
        append("targetNumberOfNodes=$targetNumberOfNodes,")
        append("totalResizeDataInMegaBytes=$totalResizeDataInMegaBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = avgResizeRateInMegaBytesPerSecond?.hashCode() ?: 0
        result = 31 * result + (dataTransferProgressPercent?.hashCode() ?: 0)
        result = 31 * result + (elapsedTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeToCompletionInSeconds?.hashCode() ?: 0)
        result = 31 * result + (importTablesCompleted?.hashCode() ?: 0)
        result = 31 * result + (importTablesInProgress?.hashCode() ?: 0)
        result = 31 * result + (importTablesNotStarted?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (progressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (resizeType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetClusterType?.hashCode() ?: 0)
        result = 31 * result + (targetEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (targetNodeType?.hashCode() ?: 0)
        result = 31 * result + (targetNumberOfNodes ?: 0)
        result = 31 * result + (totalResizeDataInMegaBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CancelResizeResponse

        if (!(avgResizeRateInMegaBytesPerSecond?.equals(other.avgResizeRateInMegaBytesPerSecond) ?: (other.avgResizeRateInMegaBytesPerSecond == null))) return false
        if (!(dataTransferProgressPercent?.equals(other.dataTransferProgressPercent) ?: (other.dataTransferProgressPercent == null))) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedTimeToCompletionInSeconds != other.estimatedTimeToCompletionInSeconds) return false
        if (importTablesCompleted != other.importTablesCompleted) return false
        if (importTablesInProgress != other.importTablesInProgress) return false
        if (importTablesNotStarted != other.importTablesNotStarted) return false
        if (message != other.message) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (resizeType != other.resizeType) return false
        if (status != other.status) return false
        if (targetClusterType != other.targetClusterType) return false
        if (targetEncryptionType != other.targetEncryptionType) return false
        if (targetNodeType != other.targetNodeType) return false
        if (targetNumberOfNodes != other.targetNumberOfNodes) return false
        if (totalResizeDataInMegaBytes != other.totalResizeDataInMegaBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CancelResizeResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.
         */
        public var avgResizeRateInMegaBytesPerSecond: kotlin.Double? = null
        /**
         * The percent of data transferred from source cluster to target cluster.
         */
        public var dataTransferProgressPercent: kotlin.Double? = null
        /**
         * The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.
         */
        public var elapsedTimeInSeconds: kotlin.Long? = null
        /**
         * The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.
         */
        public var estimatedTimeToCompletionInSeconds: kotlin.Long? = null
        /**
         * The names of tables that have been completely imported .
         *
         * Valid Values: List of table names.
         */
        public var importTablesCompleted: List<String>? = null
        /**
         * The names of tables that are being currently imported.
         *
         * Valid Values: List of table names.
         */
        public var importTablesInProgress: List<String>? = null
        /**
         * The names of tables that have not been yet imported.
         *
         * Valid Values: List of table names
         */
        public var importTablesNotStarted: List<String>? = null
        /**
         * An optional string to provide additional details about the resize action.
         */
        public var message: kotlin.String? = null
        /**
         * While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).
         */
        public var progressInMegaBytes: kotlin.Long? = null
        /**
         * An enum with possible values of `ClassicResize` and `ElasticResize`. These values describe the type of resize operation being performed.
         */
        public var resizeType: kotlin.String? = null
        /**
         * The status of the resize operation.
         *
         * Valid Values: `NONE` | `IN_PROGRESS` | `FAILED` | `SUCCEEDED` | `CANCELLING`
         */
        public var status: kotlin.String? = null
        /**
         * The cluster type after the resize operation is complete.
         *
         * Valid Values: `multi-node` | `single-node`
         */
        public var targetClusterType: kotlin.String? = null
        /**
         * The type of encryption for the cluster after the resize is complete.
         *
         * Possible values are `KMS` and `None`.
         */
        public var targetEncryptionType: kotlin.String? = null
        /**
         * The node type that the cluster will have after the resize operation is complete.
         */
        public var targetNodeType: kotlin.String? = null
        /**
         * The number of nodes that the cluster will have after the resize operation is complete.
         */
        public var targetNumberOfNodes: kotlin.Int? = null
        /**
         * The estimated total amount of data, in megabytes, on the cluster before the resize operation began.
         */
        public var totalResizeDataInMegaBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CancelResizeResponse) : this() {
            this.avgResizeRateInMegaBytesPerSecond = x.avgResizeRateInMegaBytesPerSecond
            this.dataTransferProgressPercent = x.dataTransferProgressPercent
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedTimeToCompletionInSeconds = x.estimatedTimeToCompletionInSeconds
            this.importTablesCompleted = x.importTablesCompleted
            this.importTablesInProgress = x.importTablesInProgress
            this.importTablesNotStarted = x.importTablesNotStarted
            this.message = x.message
            this.progressInMegaBytes = x.progressInMegaBytes
            this.resizeType = x.resizeType
            this.status = x.status
            this.targetClusterType = x.targetClusterType
            this.targetEncryptionType = x.targetEncryptionType
            this.targetNodeType = x.targetNodeType
            this.targetNumberOfNodes = x.targetNumberOfNodes
            this.totalResizeDataInMegaBytes = x.totalResizeDataInMegaBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CancelResizeResponse = CancelResizeResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
