/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.redshift.serde;

import aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotResponse;
import aws.sdk.kotlin.services.redshift.model.RedshiftException;
import aws.sdk.kotlin.services.redshift.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.redshift.serde.ClusterNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.ClusterSnapshotAlreadyExistsFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.ClusterSnapshotQuotaExceededFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.InvalidClusterStateFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.InvalidRetentionPeriodFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.InvalidTagFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.SnapshotDocumentDeserializerKt;
import aws.sdk.kotlin.services.redshift.serde.TagLimitExceededFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwCreateClusterSnapshotError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeCreateClusterSnapshotOperationBody", "", "builder", "Laws/sdk/kotlin/services/redshift/model/CreateClusterSnapshotResponse$Builder;", "redshift"})
@SourceDebugExtension(value={"SMAP\nCreateClusterSnapshotOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateClusterSnapshotOperationDeserializer.kt\naws/sdk/kotlin/services/redshift/serde/CreateClusterSnapshotOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class CreateClusterSnapshotOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwCreateClusterSnapshotError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-CreateClusterSnapshotOperationDeserializerKt$throwCreateClusterSnapshotError$errorDetails$1 = false;
                $i$a$-checkNotNull-CreateClusterSnapshotOperationDeserializerKt$throwCreateClusterSnapshotError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-CreateClusterSnapshotOperationDeserializerKt$throwCreateClusterSnapshotError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-CreateClusterSnapshotOperationDeserializerKt$throwCreateClusterSnapshotError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new RedshiftException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-CreateClusterSnapshotOperationDeserializerKt$throwCreateClusterSnapshotError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-CreateClusterSnapshotOperationDeserializerKt$throwCreateClusterSnapshotError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case 1493924698: {
                if (var7_9.equals("InvalidRetentionPeriodFault")) {
                    tmp = 1;
                }
                break;
            }
            case -803383378: {
                if (var7_9.equals("TagLimitExceededFault")) {
                    tmp = 2;
                }
                break;
            }
            case -2077139863: {
                if (var7_9.equals("ClusterNotFound")) {
                    tmp = 3;
                }
                break;
            }
            case 1103100342: {
                if (var7_9.equals("ClusterSnapshotAlreadyExists")) {
                    tmp = 4;
                }
                break;
            }
            case 1774692557: {
                if (var7_9.equals("ClusterSnapshotQuotaExceeded")) {
                    tmp = 5;
                }
                break;
            }
            case 1238589855: {
                if (var7_9.equals("InvalidTagFault")) {
                    tmp = 6;
                }
                break;
            }
            case 1191428654: {
                if (var7_9.equals("InvalidClusterState")) {
                    tmp = 7;
                }
                break;
            }
        }
        switch (tmp) {
            case 4: {
                v1 = new ClusterSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new ClusterSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new RedshiftException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeCreateClusterSnapshotOperationBody(CreateClusterSnapshotResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "CreateClusterSnapshot");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"Snapshot")) {
                builder.setSnapshot(SnapshotDocumentDeserializerKt.deserializeSnapshotDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwCreateClusterSnapshotError(ExecutionContext context, HttpCall call, byte[] payload) {
        return CreateClusterSnapshotOperationDeserializerKt.throwCreateClusterSnapshotError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeCreateClusterSnapshotOperationBody(CreateClusterSnapshotResponse.Builder builder, byte[] payload) {
        CreateClusterSnapshotOperationDeserializerKt.deserializeCreateClusterSnapshotOperationBody(builder, payload);
    }
}

