// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RestoreFromClusterSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<RestoreFromClusterSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RestoreFromClusterSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreFromClusterSnapshotError(context, call, payload)
        }
        val builder = RestoreFromClusterSnapshotResponse.Builder()

        if (payload != null) {
            deserializeRestoreFromClusterSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRestoreFromClusterSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidReservedNodeState" -> InvalidReservedNodeStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterQuotaExceeded" -> ClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeAlreadyExists" -> ReservedNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRestore" -> InvalidRestoreFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceUnavailableFault" -> DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedCall, payload)
        "HsmConfigurationNotFoundFault" -> HsmConfigurationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NumberOfNodesQuotaExceeded" -> NumberOfNodesQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "AccessToSnapshotDenied" -> AccessToSnapshotDeniedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeAlreadyMigrated" -> ReservedNodeAlreadyMigratedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "HsmClientCertificateNotFoundFault" -> HsmClientCertificateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterSubnetGroupStateFault" -> InvalidClusterSubnetGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSecurityGroupNotFound" -> ClusterSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterAlreadyExists" -> ClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterParameterGroupNotFound" -> ClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeNotFound" -> ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSubnetGroupNotFoundFault" -> ClusterSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "Ipv6CidrBlockNotFoundFault" -> Ipv6CidrBlockNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientClusterCapacity" -> InsufficientClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSnapshotNotFound" -> ClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterTrack" -> InvalidClusterTrackFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidElasticIpFault" -> InvalidElasticIpFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterSnapshotState" -> InvalidClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NumberOfNodesPerClusterLimitExceeded" -> NumberOfNodesPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreFromClusterSnapshotOperationBody(builder: RestoreFromClusterSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RestoreFromClusterSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Cluster com.amazonaws.redshift#RestoreFromClusterSnapshotResult$Cluster
            "Cluster" -> builder.cluster = deserializeClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
