// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.PartnerIntegrationInfo
import aws.sdk.kotlin.services.redshift.model.PartnerIntegrationStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializePartnerIntegrationInfoDocument(reader: XmlTagReader): PartnerIntegrationInfo {
    val builder = PartnerIntegrationInfo.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DatabaseName com.amazonaws.redshift#PartnerIntegrationInfo$DatabaseName
            "DatabaseName" -> builder.databaseName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#PartnerIntegrationDatabaseName`)" }
            // PartnerName com.amazonaws.redshift#PartnerIntegrationInfo$PartnerName
            "PartnerName" -> builder.partnerName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#PartnerIntegrationPartnerName`)" }
            // Status com.amazonaws.redshift#PartnerIntegrationInfo$Status
            "Status" -> builder.status = curr.tryData()
                .parse { PartnerIntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#PartnerIntegrationStatus`)" }
            // StatusMessage com.amazonaws.redshift#PartnerIntegrationInfo$StatusMessage
            "StatusMessage" -> builder.statusMessage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#PartnerIntegrationStatusMessage`)" }
            // CreatedAt com.amazonaws.redshift#PartnerIntegrationInfo$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // UpdatedAt com.amazonaws.redshift#PartnerIntegrationInfo$UpdatedAt
            "UpdatedAt" -> builder.updatedAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
