// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ModifyCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyCustomDomainAssociationOperationDeserializer: HttpDeserializer.NonStreaming<ModifyCustomDomainAssociationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyCustomDomainAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyCustomDomainAssociationError(context, call, payload)
        }
        val builder = ModifyCustomDomainAssociationResponse.Builder()

        if (payload != null) {
            deserializeModifyCustomDomainAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyCustomDomainAssociationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CustomDomainAssociationNotFoundFault" -> CustomDomainAssociationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CustomCnameAssociationFault" -> CustomCnameAssociationFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyCustomDomainAssociationOperationBody(builder: ModifyCustomDomainAssociationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyCustomDomainAssociation")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterIdentifier com.amazonaws.redshift#ModifyCustomDomainAssociationResult$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CustomDomainCertExpiryTime com.amazonaws.redshift#ModifyCustomDomainAssociationResult$CustomDomainCertExpiryTime
            "CustomDomainCertExpiryTime" -> builder.customDomainCertExpiryTime = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CustomDomainCertificateArn com.amazonaws.redshift#ModifyCustomDomainAssociationResult$CustomDomainCertificateArn
            "CustomDomainCertificateArn" -> builder.customDomainCertificateArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#CustomDomainCertificateArnString`)" }
            // CustomDomainName com.amazonaws.redshift#ModifyCustomDomainAssociationResult$CustomDomainName
            "CustomDomainName" -> builder.customDomainName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#CustomDomainNameString`)" }
            else -> {}
        }
        curr.drop()
    }
}
