// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.InboundIntegration
import aws.sdk.kotlin.services.redshift.model.ZeroEtlIntegrationStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeInboundIntegrationDocument(reader: XmlTagReader): InboundIntegration {
    val builder = InboundIntegration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // IntegrationArn com.amazonaws.redshift#InboundIntegration$IntegrationArn
            "IntegrationArn" -> builder.integrationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceArn com.amazonaws.redshift#InboundIntegration$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetArn com.amazonaws.redshift#InboundIntegration$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#InboundIntegration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ZeroEtlIntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ZeroETLIntegrationStatus`)" }
            // Errors com.amazonaws.redshift#InboundIntegration$Errors
            "Errors" -> builder.errors = deserializeIntegrationErrorListShape(curr)
            // CreateTime com.amazonaws.redshift#InboundIntegration$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
