// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ReservedNodeConfigurationOption
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetReservedNodeExchangeConfigurationOptionsOperationDeserializer: HttpDeserializer.NonStreaming<GetReservedNodeExchangeConfigurationOptionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetReservedNodeExchangeConfigurationOptionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetReservedNodeExchangeConfigurationOptionsError(context, call, payload)
        }
        val builder = GetReservedNodeExchangeConfigurationOptionsResponse.Builder()

        if (payload != null) {
            deserializeGetReservedNodeExchangeConfigurationOptionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetReservedNodeExchangeConfigurationOptionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedNodeAlreadyMigrated" -> ReservedNodeAlreadyMigratedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReservedNodeState" -> InvalidReservedNodeStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSnapshotNotFound" -> ClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceUnavailableFault" -> DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeNotFound" -> ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReservedNodeExchangeConfigurationOptionsOperationBody(builder: GetReservedNodeExchangeConfigurationOptionsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "GetReservedNodeExchangeConfigurationOptions")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Marker com.amazonaws.redshift#GetReservedNodeExchangeConfigurationOptionsOutputMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ReservedNodeConfigurationOptionList com.amazonaws.redshift#GetReservedNodeExchangeConfigurationOptionsOutputMessage$ReservedNodeConfigurationOptionList
            "ReservedNodeConfigurationOptionList" -> builder.reservedNodeConfigurationOptionList = deserializeReservedNodeConfigurationOptionListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
