// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.AuthorizationStatus
import aws.sdk.kotlin.services.redshift.model.EndpointAuthorization
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEndpointAuthorizationDocument(reader: XmlTagReader): EndpointAuthorization {
    val builder = EndpointAuthorization.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Grantor com.amazonaws.redshift#EndpointAuthorization$Grantor
            "Grantor" -> builder.grantor = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Grantee com.amazonaws.redshift#EndpointAuthorization$Grantee
            "Grantee" -> builder.grantee = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterIdentifier com.amazonaws.redshift#EndpointAuthorization$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // AuthorizeTime com.amazonaws.redshift#EndpointAuthorization$AuthorizeTime
            "AuthorizeTime" -> builder.authorizeTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // ClusterStatus com.amazonaws.redshift#EndpointAuthorization$ClusterStatus
            "ClusterStatus" -> builder.clusterStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#EndpointAuthorization$Status
            "Status" -> builder.status = curr.tryData()
                .parse { AuthorizationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#AuthorizationStatus`)" }
            // AllowedAllVPCs com.amazonaws.redshift#EndpointAuthorization$AllowedAllVPCs
            "AllowedAllVPCs" -> builder.allowedAllVpcs = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // AllowedVPCs com.amazonaws.redshift#EndpointAuthorization$AllowedVPCs
            "AllowedVPCs" -> builder.allowedVpcs = deserializeVpcIdentifierListShape(curr)
            // EndpointCount com.amazonaws.redshift#EndpointAuthorization$EndpointCount
            "EndpointCount" -> builder.endpointCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
