// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateHsmConfigurationResponse
import aws.sdk.kotlin.services.redshift.model.HsmConfiguration
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateHsmConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<CreateHsmConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateHsmConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateHsmConfigurationError(context, call, payload)
        }
        val builder = CreateHsmConfigurationResponse.Builder()

        if (payload != null) {
            deserializeCreateHsmConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateHsmConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "HsmConfigurationQuotaExceededFault" -> HsmConfigurationQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        "HsmConfigurationAlreadyExistsFault" -> HsmConfigurationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHsmConfigurationOperationBody(builder: CreateHsmConfigurationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateHsmConfiguration")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // HsmConfiguration com.amazonaws.redshift#CreateHsmConfigurationResult$HsmConfiguration
            "HsmConfiguration" -> builder.hsmConfiguration = deserializeHsmConfigurationDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
