// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.ScheduleState
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeClusterDocument(reader: XmlTagReader): Cluster {
    val builder = Cluster.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterIdentifier com.amazonaws.redshift#Cluster$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NodeType com.amazonaws.redshift#Cluster$NodeType
            "NodeType" -> builder.nodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterStatus com.amazonaws.redshift#Cluster$ClusterStatus
            "ClusterStatus" -> builder.clusterStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterAvailabilityStatus com.amazonaws.redshift#Cluster$ClusterAvailabilityStatus
            "ClusterAvailabilityStatus" -> builder.clusterAvailabilityStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ModifyStatus com.amazonaws.redshift#Cluster$ModifyStatus
            "ModifyStatus" -> builder.modifyStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // MasterUsername com.amazonaws.redshift#Cluster$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // DBName com.amazonaws.redshift#Cluster$DBName
            "DBName" -> builder.dbName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Endpoint com.amazonaws.redshift#Cluster$Endpoint
            "Endpoint" -> builder.endpoint = deserializeEndpointDocument(curr)
            // ClusterCreateTime com.amazonaws.redshift#Cluster$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // AutomatedSnapshotRetentionPeriod com.amazonaws.redshift#Cluster$AutomatedSnapshotRetentionPeriod
            "AutomatedSnapshotRetentionPeriod" -> builder.automatedSnapshotRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // ManualSnapshotRetentionPeriod com.amazonaws.redshift#Cluster$ManualSnapshotRetentionPeriod
            "ManualSnapshotRetentionPeriod" -> builder.manualSnapshotRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // ClusterSecurityGroups com.amazonaws.redshift#Cluster$ClusterSecurityGroups
            "ClusterSecurityGroups" -> builder.clusterSecurityGroups = deserializeClusterSecurityGroupMembershipListShape(curr)
            // VpcSecurityGroups com.amazonaws.redshift#Cluster$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            // ClusterParameterGroups com.amazonaws.redshift#Cluster$ClusterParameterGroups
            "ClusterParameterGroups" -> builder.clusterParameterGroups = deserializeClusterParameterGroupStatusListShape(curr)
            // ClusterSubnetGroupName com.amazonaws.redshift#Cluster$ClusterSubnetGroupName
            "ClusterSubnetGroupName" -> builder.clusterSubnetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // VpcId com.amazonaws.redshift#Cluster$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // AvailabilityZone com.amazonaws.redshift#Cluster$AvailabilityZone
            "AvailabilityZone" -> builder.availabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // PreferredMaintenanceWindow com.amazonaws.redshift#Cluster$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // PendingModifiedValues com.amazonaws.redshift#Cluster$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializePendingModifiedValuesDocument(curr)
            // ClusterVersion com.amazonaws.redshift#Cluster$ClusterVersion
            "ClusterVersion" -> builder.clusterVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // AllowVersionUpgrade com.amazonaws.redshift#Cluster$AllowVersionUpgrade
            "AllowVersionUpgrade" -> builder.allowVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // NumberOfNodes com.amazonaws.redshift#Cluster$NumberOfNodes
            "NumberOfNodes" -> builder.numberOfNodes = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // PubliclyAccessible com.amazonaws.redshift#Cluster$PubliclyAccessible
            "PubliclyAccessible" -> builder.publiclyAccessible = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // Encrypted com.amazonaws.redshift#Cluster$Encrypted
            "Encrypted" -> builder.encrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // RestoreStatus com.amazonaws.redshift#Cluster$RestoreStatus
            "RestoreStatus" -> builder.restoreStatus = deserializeRestoreStatusDocument(curr)
            // DataTransferProgress com.amazonaws.redshift#Cluster$DataTransferProgress
            "DataTransferProgress" -> builder.dataTransferProgress = deserializeDataTransferProgressDocument(curr)
            // HsmStatus com.amazonaws.redshift#Cluster$HsmStatus
            "HsmStatus" -> builder.hsmStatus = deserializeHsmStatusDocument(curr)
            // ClusterSnapshotCopyStatus com.amazonaws.redshift#Cluster$ClusterSnapshotCopyStatus
            "ClusterSnapshotCopyStatus" -> builder.clusterSnapshotCopyStatus = deserializeClusterSnapshotCopyStatusDocument(curr)
            // ClusterPublicKey com.amazonaws.redshift#Cluster$ClusterPublicKey
            "ClusterPublicKey" -> builder.clusterPublicKey = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterNodes com.amazonaws.redshift#Cluster$ClusterNodes
            "ClusterNodes" -> builder.clusterNodes = deserializeClusterNodesListShape(curr)
            // ElasticIpStatus com.amazonaws.redshift#Cluster$ElasticIpStatus
            "ElasticIpStatus" -> builder.elasticIpStatus = deserializeElasticIpStatusDocument(curr)
            // ClusterRevisionNumber com.amazonaws.redshift#Cluster$ClusterRevisionNumber
            "ClusterRevisionNumber" -> builder.clusterRevisionNumber = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Tags com.amazonaws.redshift#Cluster$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // KmsKeyId com.amazonaws.redshift#Cluster$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EnhancedVpcRouting com.amazonaws.redshift#Cluster$EnhancedVpcRouting
            "EnhancedVpcRouting" -> builder.enhancedVpcRouting = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // IamRoles com.amazonaws.redshift#Cluster$IamRoles
            "IamRoles" -> builder.iamRoles = deserializeClusterIamRoleListShape(curr)
            // PendingActions com.amazonaws.redshift#Cluster$PendingActions
            "PendingActions" -> builder.pendingActions = deserializePendingActionsListShape(curr)
            // MaintenanceTrackName com.amazonaws.redshift#Cluster$MaintenanceTrackName
            "MaintenanceTrackName" -> builder.maintenanceTrackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ElasticResizeNumberOfNodeOptions com.amazonaws.redshift#Cluster$ElasticResizeNumberOfNodeOptions
            "ElasticResizeNumberOfNodeOptions" -> builder.elasticResizeNumberOfNodeOptions = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // DeferredMaintenanceWindows com.amazonaws.redshift#Cluster$DeferredMaintenanceWindows
            "DeferredMaintenanceWindows" -> builder.deferredMaintenanceWindows = deserializeDeferredMaintenanceWindowsListShape(curr)
            // SnapshotScheduleIdentifier com.amazonaws.redshift#Cluster$SnapshotScheduleIdentifier
            "SnapshotScheduleIdentifier" -> builder.snapshotScheduleIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SnapshotScheduleState com.amazonaws.redshift#Cluster$SnapshotScheduleState
            "SnapshotScheduleState" -> builder.snapshotScheduleState = curr.tryData()
                .parse { ScheduleState.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ScheduleState`)" }
            // ExpectedNextSnapshotScheduleTime com.amazonaws.redshift#Cluster$ExpectedNextSnapshotScheduleTime
            "ExpectedNextSnapshotScheduleTime" -> builder.expectedNextSnapshotScheduleTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // ExpectedNextSnapshotScheduleTimeStatus com.amazonaws.redshift#Cluster$ExpectedNextSnapshotScheduleTimeStatus
            "ExpectedNextSnapshotScheduleTimeStatus" -> builder.expectedNextSnapshotScheduleTimeStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NextMaintenanceWindowStartTime com.amazonaws.redshift#Cluster$NextMaintenanceWindowStartTime
            "NextMaintenanceWindowStartTime" -> builder.nextMaintenanceWindowStartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // ResizeInfo com.amazonaws.redshift#Cluster$ResizeInfo
            "ResizeInfo" -> builder.resizeInfo = deserializeResizeInfoDocument(curr)
            // AvailabilityZoneRelocationStatus com.amazonaws.redshift#Cluster$AvailabilityZoneRelocationStatus
            "AvailabilityZoneRelocationStatus" -> builder.availabilityZoneRelocationStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterNamespaceArn com.amazonaws.redshift#Cluster$ClusterNamespaceArn
            "ClusterNamespaceArn" -> builder.clusterNamespaceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TotalStorageCapacityInMegaBytes com.amazonaws.redshift#Cluster$TotalStorageCapacityInMegaBytes
            "TotalStorageCapacityInMegaBytes" -> builder.totalStorageCapacityInMegaBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            // AquaConfiguration com.amazonaws.redshift#Cluster$AquaConfiguration
            "AquaConfiguration" -> builder.aquaConfiguration = deserializeAquaConfigurationDocument(curr)
            // DefaultIamRoleArn com.amazonaws.redshift#Cluster$DefaultIamRoleArn
            "DefaultIamRoleArn" -> builder.defaultIamRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ReservedNodeExchangeStatus com.amazonaws.redshift#Cluster$ReservedNodeExchangeStatus
            "ReservedNodeExchangeStatus" -> builder.reservedNodeExchangeStatus = deserializeReservedNodeExchangeStatusDocument(curr)
            // CustomDomainName com.amazonaws.redshift#Cluster$CustomDomainName
            "CustomDomainName" -> builder.customDomainName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CustomDomainCertificateArn com.amazonaws.redshift#Cluster$CustomDomainCertificateArn
            "CustomDomainCertificateArn" -> builder.customDomainCertificateArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CustomDomainCertificateExpiryDate com.amazonaws.redshift#Cluster$CustomDomainCertificateExpiryDate
            "CustomDomainCertificateExpiryDate" -> builder.customDomainCertificateExpiryDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // MasterPasswordSecretArn com.amazonaws.redshift#Cluster$MasterPasswordSecretArn
            "MasterPasswordSecretArn" -> builder.masterPasswordSecretArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // MasterPasswordSecretKmsKeyId com.amazonaws.redshift#Cluster$MasterPasswordSecretKmsKeyId
            "MasterPasswordSecretKmsKeyId" -> builder.masterPasswordSecretKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // IpAddressType com.amazonaws.redshift#Cluster$IpAddressType
            "IpAddressType" -> builder.ipAddressType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // MultiAZ com.amazonaws.redshift#Cluster$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // MultiAZSecondary com.amazonaws.redshift#Cluster$MultiAZSecondary
            "MultiAZSecondary" -> builder.multiAzSecondary = deserializeSecondaryClusterInfoDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
