// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterDbRevision
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeClusterDbRevisionDocument(reader: XmlTagReader): ClusterDbRevision {
    val builder = ClusterDbRevision.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterIdentifier com.amazonaws.redshift#ClusterDbRevision$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CurrentDatabaseRevision com.amazonaws.redshift#ClusterDbRevision$CurrentDatabaseRevision
            "CurrentDatabaseRevision" -> builder.currentDatabaseRevision = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // DatabaseRevisionReleaseDate com.amazonaws.redshift#ClusterDbRevision$DatabaseRevisionReleaseDate
            "DatabaseRevisionReleaseDate" -> builder.databaseRevisionReleaseDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // RevisionTargets com.amazonaws.redshift#ClusterDbRevision$RevisionTargets
            "RevisionTargets" -> builder.revisionTargets = deserializeRevisionTargetsListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
