// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.
 *
 *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public class SnapshotCopyGrant private constructor(builder: Builder) {
    /**
     * The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the snapshot copy grant.
     */
    public val snapshotCopyGrantName: kotlin.String? = builder.snapshotCopyGrantName
    /**
     * A list of tag instances.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.SnapshotCopyGrant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotCopyGrant(")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotCopyGrant

        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.SnapshotCopyGrant = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the snapshot copy grant.
         */
        public var snapshotCopyGrantName: kotlin.String? = null
        /**
         * A list of tag instances.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.SnapshotCopyGrant) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.SnapshotCopyGrant = SnapshotCopyGrant(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
