// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class RestoreTableFromClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Redshift cluster to restore the table to.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * Indicates whether name identifiers for database, schema, and table are case sensitive. If `true`, the names are case sensitive. If `false` (default), the names are not case sensitive.
     */
    public val enableCaseSensitiveIdentifier: kotlin.Boolean? = builder.enableCaseSensitiveIdentifier
    /**
     * The name of the table to create as a result of the current request.
     */
    public val newTableName: kotlin.String? = builder.newTableName
    /**
     * The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon Redshift cluster specified by the `ClusterIdentifier` parameter.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * The name of the source database that contains the table to restore from.
     */
    public val sourceDatabaseName: kotlin.String? = builder.sourceDatabaseName
    /**
     * The name of the source schema that contains the table to restore from. If you do not specify a `SourceSchemaName` value, the default is `public`.
     */
    public val sourceSchemaName: kotlin.String? = builder.sourceSchemaName
    /**
     * The name of the source table to restore from.
     */
    public val sourceTableName: kotlin.String? = builder.sourceTableName
    /**
     * The name of the database to restore the table to.
     */
    public val targetDatabaseName: kotlin.String? = builder.targetDatabaseName
    /**
     * The name of the schema to restore the table to.
     */
    public val targetSchemaName: kotlin.String? = builder.targetSchemaName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.RestoreTableFromClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTableFromClusterSnapshotRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("enableCaseSensitiveIdentifier=$enableCaseSensitiveIdentifier,")
        append("newTableName=$newTableName,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("sourceDatabaseName=$sourceDatabaseName,")
        append("sourceSchemaName=$sourceSchemaName,")
        append("sourceTableName=$sourceTableName,")
        append("targetDatabaseName=$targetDatabaseName,")
        append("targetSchemaName=$targetSchemaName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (enableCaseSensitiveIdentifier?.hashCode() ?: 0)
        result = 31 * result + (newTableName?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (sourceSchemaName?.hashCode() ?: 0)
        result = 31 * result + (sourceTableName?.hashCode() ?: 0)
        result = 31 * result + (targetDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (targetSchemaName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTableFromClusterSnapshotRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (enableCaseSensitiveIdentifier != other.enableCaseSensitiveIdentifier) return false
        if (newTableName != other.newTableName) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (sourceDatabaseName != other.sourceDatabaseName) return false
        if (sourceSchemaName != other.sourceSchemaName) return false
        if (sourceTableName != other.sourceTableName) return false
        if (targetDatabaseName != other.targetDatabaseName) return false
        if (targetSchemaName != other.targetSchemaName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.RestoreTableFromClusterSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Redshift cluster to restore the table to.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * Indicates whether name identifiers for database, schema, and table are case sensitive. If `true`, the names are case sensitive. If `false` (default), the names are not case sensitive.
         */
        public var enableCaseSensitiveIdentifier: kotlin.Boolean? = null
        /**
         * The name of the table to create as a result of the current request.
         */
        public var newTableName: kotlin.String? = null
        /**
         * The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon Redshift cluster specified by the `ClusterIdentifier` parameter.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * The name of the source database that contains the table to restore from.
         */
        public var sourceDatabaseName: kotlin.String? = null
        /**
         * The name of the source schema that contains the table to restore from. If you do not specify a `SourceSchemaName` value, the default is `public`.
         */
        public var sourceSchemaName: kotlin.String? = null
        /**
         * The name of the source table to restore from.
         */
        public var sourceTableName: kotlin.String? = null
        /**
         * The name of the database to restore the table to.
         */
        public var targetDatabaseName: kotlin.String? = null
        /**
         * The name of the schema to restore the table to.
         */
        public var targetSchemaName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.RestoreTableFromClusterSnapshotRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.enableCaseSensitiveIdentifier = x.enableCaseSensitiveIdentifier
            this.newTableName = x.newTableName
            this.snapshotIdentifier = x.snapshotIdentifier
            this.sourceDatabaseName = x.sourceDatabaseName
            this.sourceSchemaName = x.sourceSchemaName
            this.sourceTableName = x.sourceTableName
            this.targetDatabaseName = x.targetDatabaseName
            this.targetSchemaName = x.targetSchemaName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.RestoreTableFromClusterSnapshotRequest = RestoreTableFromClusterSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
