// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class EnableSnapshotCopyRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the source cluster to copy snapshots from.
     *
     * Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The destination Amazon Web Services Region that you want to copy snapshots to.
     *
     * Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region) in the Amazon Web Services General Reference.
     */
    public val destinationRegion: kotlin.String? = builder.destinationRegion
    /**
     * The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The number of days to retain automated snapshots in the destination region after they are copied from the source region.
     *
     * Default: 7.
     *
     * Constraints: Must be at least 1 and no more than 35.
     */
    public val retentionPeriod: kotlin.Int? = builder.retentionPeriod
    /**
     * The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region.
     */
    public val snapshotCopyGrantName: kotlin.String? = builder.snapshotCopyGrantName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.EnableSnapshotCopyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableSnapshotCopyRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("destinationRegion=$destinationRegion,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("retentionPeriod=$retentionPeriod,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (destinationRegion?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableSnapshotCopyRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (destinationRegion != other.destinationRegion) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.EnableSnapshotCopyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the source cluster to copy snapshots from.
         *
         * Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The destination Amazon Web Services Region that you want to copy snapshots to.
         *
         * Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region) in the Amazon Web Services General Reference.
         */
        public var destinationRegion: kotlin.String? = null
        /**
         * The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The number of days to retain automated snapshots in the destination region after they are copied from the source region.
         *
         * Default: 7.
         *
         * Constraints: Must be at least 1 and no more than 35.
         */
        public var retentionPeriod: kotlin.Int? = null
        /**
         * The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region.
         */
        public var snapshotCopyGrantName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.EnableSnapshotCopyRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.destinationRegion = x.destinationRegion
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.retentionPeriod = x.retentionPeriod
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.EnableSnapshotCopyRequest = EnableSnapshotCopyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
