// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class DescribeClusterSecurityGroupsRequest private constructor(builder: Builder) {
    /**
     * The name of a cluster security group for which you are requesting details. You must specify either the **Marker** parameter or a **ClusterSecurityGroupName** parameter, but not both.
     *
     *  Example: `securitygroup1`
     */
    public val clusterSecurityGroupName: kotlin.String? = builder.clusterSecurityGroupName
    /**
     * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterSecurityGroups request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
     *
     * Constraints: You must specify either the **ClusterSecurityGroupName** parameter or the **Marker** parameter, but not both.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     *
     * Default: `100`
     *
     * Constraints: minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.
     */
    public val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.
     */
    public val tagValues: List<String>? = builder.tagValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClusterSecurityGroupsRequest(")
        append("clusterSecurityGroupName=$clusterSecurityGroupName,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterSecurityGroupName?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeClusterSecurityGroupsRequest

        if (clusterSecurityGroupName != other.clusterSecurityGroupName) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of a cluster security group for which you are requesting details. You must specify either the **Marker** parameter or a **ClusterSecurityGroupName** parameter, but not both.
         *
         *  Example: `securitygroup1`
         */
        public var clusterSecurityGroupName: kotlin.String? = null
        /**
         * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterSecurityGroups request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
         *
         * Constraints: You must specify either the **ClusterSecurityGroupName** parameter or the **Marker** parameter, but not both.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         *
         * Default: `100`
         *
         * Constraints: minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.
         */
        public var tagKeys: List<String>? = null
        /**
         * A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.
         */
        public var tagValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsRequest) : this() {
            this.clusterSecurityGroupName = x.clusterSecurityGroupName
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsRequest = DescribeClusterSecurityGroupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
