// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.UpdatePartnerStatusResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class UpdatePartnerStatusOperationDeserializer: HttpDeserializer.NonStreaming<UpdatePartnerStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdatePartnerStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdatePartnerStatusError(context, call, payload)
        }
        val builder = UpdatePartnerStatusResponse.Builder()

        if (payload != null) {
            deserializeUpdatePartnerStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdatePartnerStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PartnerNotFound" -> PartnerNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedPartnerIntegration" -> UnauthorizedPartnerIntegrationFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePartnerStatusOperationBody(builder: UpdatePartnerStatusResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "UpdatePartnerStatus")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DatabaseName com.amazonaws.redshift#PartnerIntegrationOutputMessage$DatabaseName
            "DatabaseName" -> builder.databaseName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#PartnerIntegrationDatabaseName`)" }
            // PartnerName com.amazonaws.redshift#PartnerIntegrationOutputMessage$PartnerName
            "PartnerName" -> builder.partnerName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#PartnerIntegrationPartnerName`)" }
            else -> {}
        }
        curr.drop()
    }
}
