// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.TableRestoreStatus
import aws.sdk.kotlin.services.redshift.model.TableRestoreStatusType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeTableRestoreStatusDocument(reader: XmlTagReader): TableRestoreStatus {
    val builder = TableRestoreStatus.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // TableRestoreRequestId com.amazonaws.redshift#TableRestoreStatus$TableRestoreRequestId
            "TableRestoreRequestId" -> builder.tableRestoreRequestId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#TableRestoreStatus$Status
            "Status" -> builder.status = curr.tryData()
                .parse { TableRestoreStatusType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#TableRestoreStatusType`)" }
            // Message com.amazonaws.redshift#TableRestoreStatus$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // RequestTime com.amazonaws.redshift#TableRestoreStatus$RequestTime
            "RequestTime" -> builder.requestTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // ProgressInMegaBytes com.amazonaws.redshift#TableRestoreStatus$ProgressInMegaBytes
            "ProgressInMegaBytes" -> builder.progressInMegaBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            // TotalDataInMegaBytes com.amazonaws.redshift#TableRestoreStatus$TotalDataInMegaBytes
            "TotalDataInMegaBytes" -> builder.totalDataInMegaBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            // ClusterIdentifier com.amazonaws.redshift#TableRestoreStatus$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SnapshotIdentifier com.amazonaws.redshift#TableRestoreStatus$SnapshotIdentifier
            "SnapshotIdentifier" -> builder.snapshotIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceDatabaseName com.amazonaws.redshift#TableRestoreStatus$SourceDatabaseName
            "SourceDatabaseName" -> builder.sourceDatabaseName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceSchemaName com.amazonaws.redshift#TableRestoreStatus$SourceSchemaName
            "SourceSchemaName" -> builder.sourceSchemaName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceTableName com.amazonaws.redshift#TableRestoreStatus$SourceTableName
            "SourceTableName" -> builder.sourceTableName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetDatabaseName com.amazonaws.redshift#TableRestoreStatus$TargetDatabaseName
            "TargetDatabaseName" -> builder.targetDatabaseName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetSchemaName com.amazonaws.redshift#TableRestoreStatus$TargetSchemaName
            "TargetSchemaName" -> builder.targetSchemaName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NewTableName com.amazonaws.redshift#TableRestoreStatus$NewTableName
            "NewTableName" -> builder.newTableName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
