// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Snapshot
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeSnapshotDocument(reader: XmlTagReader): Snapshot {
    val builder = Snapshot.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SnapshotIdentifier com.amazonaws.redshift#Snapshot$SnapshotIdentifier
            "SnapshotIdentifier" -> builder.snapshotIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterIdentifier com.amazonaws.redshift#Snapshot$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SnapshotCreateTime com.amazonaws.redshift#Snapshot$SnapshotCreateTime
            "SnapshotCreateTime" -> builder.snapshotCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // Status com.amazonaws.redshift#Snapshot$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Port com.amazonaws.redshift#Snapshot$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // AvailabilityZone com.amazonaws.redshift#Snapshot$AvailabilityZone
            "AvailabilityZone" -> builder.availabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterCreateTime com.amazonaws.redshift#Snapshot$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // MasterUsername com.amazonaws.redshift#Snapshot$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterVersion com.amazonaws.redshift#Snapshot$ClusterVersion
            "ClusterVersion" -> builder.clusterVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EngineFullVersion com.amazonaws.redshift#Snapshot$EngineFullVersion
            "EngineFullVersion" -> builder.engineFullVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SnapshotType com.amazonaws.redshift#Snapshot$SnapshotType
            "SnapshotType" -> builder.snapshotType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NodeType com.amazonaws.redshift#Snapshot$NodeType
            "NodeType" -> builder.nodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NumberOfNodes com.amazonaws.redshift#Snapshot$NumberOfNodes
            "NumberOfNodes" -> builder.numberOfNodes = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // DBName com.amazonaws.redshift#Snapshot$DBName
            "DBName" -> builder.dbName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // VpcId com.amazonaws.redshift#Snapshot$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Encrypted com.amazonaws.redshift#Snapshot$Encrypted
            "Encrypted" -> builder.encrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // KmsKeyId com.amazonaws.redshift#Snapshot$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EncryptedWithHSM com.amazonaws.redshift#Snapshot$EncryptedWithHSM
            "EncryptedWithHSM" -> builder.encryptedWithHsm = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // AccountsWithRestoreAccess com.amazonaws.redshift#Snapshot$AccountsWithRestoreAccess
            "AccountsWithRestoreAccess" -> builder.accountsWithRestoreAccess = deserializeAccountsWithRestoreAccessListShape(curr)
            // OwnerAccount com.amazonaws.redshift#Snapshot$OwnerAccount
            "OwnerAccount" -> builder.ownerAccount = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TotalBackupSizeInMegaBytes com.amazonaws.redshift#Snapshot$TotalBackupSizeInMegaBytes
            "TotalBackupSizeInMegaBytes" -> builder.totalBackupSizeInMegaBytes = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#Double`)" }
            // ActualIncrementalBackupSizeInMegaBytes com.amazonaws.redshift#Snapshot$ActualIncrementalBackupSizeInMegaBytes
            "ActualIncrementalBackupSizeInMegaBytes" -> builder.actualIncrementalBackupSizeInMegaBytes = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#Double`)" }
            // BackupProgressInMegaBytes com.amazonaws.redshift#Snapshot$BackupProgressInMegaBytes
            "BackupProgressInMegaBytes" -> builder.backupProgressInMegaBytes = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#Double`)" }
            // CurrentBackupRateInMegaBytesPerSecond com.amazonaws.redshift#Snapshot$CurrentBackupRateInMegaBytesPerSecond
            "CurrentBackupRateInMegaBytesPerSecond" -> builder.currentBackupRateInMegaBytesPerSecond = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#Double`)" }
            // EstimatedSecondsToCompletion com.amazonaws.redshift#Snapshot$EstimatedSecondsToCompletion
            "EstimatedSecondsToCompletion" -> builder.estimatedSecondsToCompletion = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#Long`)" }
            // ElapsedTimeInSeconds com.amazonaws.redshift#Snapshot$ElapsedTimeInSeconds
            "ElapsedTimeInSeconds" -> builder.elapsedTimeInSeconds = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#Long`)" }
            // SourceRegion com.amazonaws.redshift#Snapshot$SourceRegion
            "SourceRegion" -> builder.sourceRegion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Tags com.amazonaws.redshift#Snapshot$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // RestorableNodeTypes com.amazonaws.redshift#Snapshot$RestorableNodeTypes
            "RestorableNodeTypes" -> builder.restorableNodeTypes = deserializeRestorableNodeTypeListShape(curr)
            // EnhancedVpcRouting com.amazonaws.redshift#Snapshot$EnhancedVpcRouting
            "EnhancedVpcRouting" -> builder.enhancedVpcRouting = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // MaintenanceTrackName com.amazonaws.redshift#Snapshot$MaintenanceTrackName
            "MaintenanceTrackName" -> builder.maintenanceTrackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ManualSnapshotRetentionPeriod com.amazonaws.redshift#Snapshot$ManualSnapshotRetentionPeriod
            "ManualSnapshotRetentionPeriod" -> builder.manualSnapshotRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#IntegerOptional`)" }
            // ManualSnapshotRemainingDays com.amazonaws.redshift#Snapshot$ManualSnapshotRemainingDays
            "ManualSnapshotRemainingDays" -> builder.manualSnapshotRemainingDays = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#IntegerOptional`)" }
            // SnapshotRetentionStartTime com.amazonaws.redshift#Snapshot$SnapshotRetentionStartTime
            "SnapshotRetentionStartTime" -> builder.snapshotRetentionStartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // MasterPasswordSecretArn com.amazonaws.redshift#Snapshot$MasterPasswordSecretArn
            "MasterPasswordSecretArn" -> builder.masterPasswordSecretArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // MasterPasswordSecretKmsKeyId com.amazonaws.redshift#Snapshot$MasterPasswordSecretKmsKeyId
            "MasterPasswordSecretKmsKeyId" -> builder.masterPasswordSecretKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SnapshotArn com.amazonaws.redshift#Snapshot$SnapshotArn
            "SnapshotArn" -> builder.snapshotArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
