// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterSecurityGroup
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RevokeClusterSecurityGroupIngressOperationDeserializer: HttpDeserializer.NonStreaming<RevokeClusterSecurityGroupIngressResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RevokeClusterSecurityGroupIngressResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRevokeClusterSecurityGroupIngressError(context, call, payload)
        }
        val builder = RevokeClusterSecurityGroupIngressResponse.Builder()

        if (payload != null) {
            deserializeRevokeClusterSecurityGroupIngressOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRevokeClusterSecurityGroupIngressError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidClusterSecurityGroupState" -> InvalidClusterSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSecurityGroupNotFound" -> ClusterSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRevokeClusterSecurityGroupIngressOperationBody(builder: RevokeClusterSecurityGroupIngressResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RevokeClusterSecurityGroupIngress")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterSecurityGroup com.amazonaws.redshift#RevokeClusterSecurityGroupIngressResult$ClusterSecurityGroup
            "ClusterSecurityGroup" -> builder.clusterSecurityGroup = deserializeClusterSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
