// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.PurchaseReservedNodeOfferingResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ReservedNode
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PurchaseReservedNodeOfferingOperationDeserializer: HttpDeserializer.NonStreaming<PurchaseReservedNodeOfferingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PurchaseReservedNodeOfferingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPurchaseReservedNodeOfferingError(context, call, payload)
        }
        val builder = PurchaseReservedNodeOfferingResponse.Builder()

        if (payload != null) {
            deserializePurchaseReservedNodeOfferingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPurchaseReservedNodeOfferingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeAlreadyExists" -> ReservedNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeQuotaExceeded" -> ReservedNodeQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePurchaseReservedNodeOfferingOperationBody(builder: PurchaseReservedNodeOfferingResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "PurchaseReservedNodeOffering")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReservedNode com.amazonaws.redshift#PurchaseReservedNodeOfferingResult$ReservedNode
            "ReservedNode" -> builder.reservedNode = deserializeReservedNodeDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
