// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ModifyUsageLimitResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Tag
import aws.sdk.kotlin.services.redshift.model.UsageLimitBreachAction
import aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType
import aws.sdk.kotlin.services.redshift.model.UsageLimitLimitType
import aws.sdk.kotlin.services.redshift.model.UsageLimitPeriod
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyUsageLimitOperationDeserializer: HttpDeserializer.NonStreaming<ModifyUsageLimitResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyUsageLimitResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyUsageLimitError(context, call, payload)
        }
        val builder = ModifyUsageLimitResponse.Builder()

        if (payload != null) {
            deserializeModifyUsageLimitOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyUsageLimitError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidUsageLimit" -> InvalidUsageLimitFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UsageLimitNotFound" -> UsageLimitNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyUsageLimitOperationBody(builder: ModifyUsageLimitResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyUsageLimit")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Amount com.amazonaws.redshift#UsageLimit$Amount
            "Amount" -> builder.amount = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#Long`)" }
            // BreachAction com.amazonaws.redshift#UsageLimit$BreachAction
            "BreachAction" -> builder.breachAction = curr.tryData()
                .parse { UsageLimitBreachAction.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#UsageLimitBreachAction`)" }
            // ClusterIdentifier com.amazonaws.redshift#UsageLimit$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // FeatureType com.amazonaws.redshift#UsageLimit$FeatureType
            "FeatureType" -> builder.featureType = curr.tryData()
                .parse { UsageLimitFeatureType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#UsageLimitFeatureType`)" }
            // LimitType com.amazonaws.redshift#UsageLimit$LimitType
            "LimitType" -> builder.limitType = curr.tryData()
                .parse { UsageLimitLimitType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#UsageLimitLimitType`)" }
            // Period com.amazonaws.redshift#UsageLimit$Period
            "Period" -> builder.period = curr.tryData()
                .parse { UsageLimitPeriod.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#UsageLimitPeriod`)" }
            // Tags com.amazonaws.redshift#UsageLimit$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // UsageLimitId com.amazonaws.redshift#UsageLimit$UsageLimitId
            "UsageLimitId" -> builder.usageLimitId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
