// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterAssociatedToSchedule
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant


internal class ModifySnapshotScheduleOperationDeserializer: HttpDeserializer.NonStreaming<ModifySnapshotScheduleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifySnapshotScheduleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifySnapshotScheduleError(context, call, payload)
        }
        val builder = ModifySnapshotScheduleResponse.Builder()

        if (payload != null) {
            deserializeModifySnapshotScheduleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifySnapshotScheduleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSchedule" -> InvalidScheduleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotScheduleUpdateInProgress" -> SnapshotScheduleUpdateInProgressFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifySnapshotScheduleOperationBody(builder: ModifySnapshotScheduleResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifySnapshotSchedule")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AssociatedClusterCount com.amazonaws.redshift#SnapshotSchedule$AssociatedClusterCount
            "AssociatedClusterCount" -> builder.associatedClusterCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#IntegerOptional`)" }
            // AssociatedClusters com.amazonaws.redshift#SnapshotSchedule$AssociatedClusters
            "AssociatedClusters" -> builder.associatedClusters = deserializeAssociatedClusterListShape(curr)
            // NextInvocations com.amazonaws.redshift#SnapshotSchedule$NextInvocations
            "NextInvocations" -> builder.nextInvocations = deserializeScheduledSnapshotTimeListShape(curr)
            // ScheduleDefinitions com.amazonaws.redshift#SnapshotSchedule$ScheduleDefinitions
            "ScheduleDefinitions" -> builder.scheduleDefinitions = deserializeScheduleDefinitionListShape(curr)
            // ScheduleDescription com.amazonaws.redshift#SnapshotSchedule$ScheduleDescription
            "ScheduleDescription" -> builder.scheduleDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ScheduleIdentifier com.amazonaws.redshift#SnapshotSchedule$ScheduleIdentifier
            "ScheduleIdentifier" -> builder.scheduleIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Tags com.amazonaws.redshift#SnapshotSchedule$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
