// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.EventSubscription
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEventSubscriptionDocument(reader: XmlTagReader): EventSubscription {
    val builder = EventSubscription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CustomerAwsId com.amazonaws.redshift#EventSubscription$CustomerAwsId
            "CustomerAwsId" -> builder.customerAwsId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CustSubscriptionId com.amazonaws.redshift#EventSubscription$CustSubscriptionId
            "CustSubscriptionId" -> builder.custSubscriptionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SnsTopicArn com.amazonaws.redshift#EventSubscription$SnsTopicArn
            "SnsTopicArn" -> builder.snsTopicArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#EventSubscription$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SubscriptionCreationTime com.amazonaws.redshift#EventSubscription$SubscriptionCreationTime
            "SubscriptionCreationTime" -> builder.subscriptionCreationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // SourceType com.amazonaws.redshift#EventSubscription$SourceType
            "SourceType" -> builder.sourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceIdsList com.amazonaws.redshift#EventSubscription$SourceIdsList
            "SourceIdsList" -> builder.sourceIdsList = deserializeSourceIdsListShape(curr)
            // EventCategoriesList com.amazonaws.redshift#EventSubscription$EventCategoriesList
            "EventCategoriesList" -> builder.eventCategoriesList = deserializeEventCategoriesListShape(curr)
            // Severity com.amazonaws.redshift#EventSubscription$Severity
            "Severity" -> builder.severity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Enabled com.amazonaws.redshift#EventSubscription$Enabled
            "Enabled" -> builder.enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // Tags com.amazonaws.redshift#EventSubscription$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
